% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_stat.R
\name{summary_stat}
\alias{summary_stat}
\title{Summary statistics for main adapt4pv package functions}
\usage{
summary_stat(object, true_pos, q = 10)
}
\arguments{
\item{object}{An object of class \code{"log.lasso"},
\code{"cisl"}, \code{"adaptive"} and \code{"*", "ps","**" } where
\code{"*"} is either \code{"adjust"}, \code{"iptw"} or \code{"mw"}
and \code{"**"} is either \code{"bic"}, \code{"hdps"} or \code{"xgb"}.}

\item{true_pos}{Character vector, names of the true positives
controls}

\item{q}{Quantile value for variable selection with
an object of class \code{"cisl"}.
Possible values are 5, 10, 15, 20. Default is 10}
}
\value{
A data frame wich details for the signal detection method
implemented in \code{object}: its number of generated signals, its
sensitivity and its false discovery rate.
}
\description{
Return the Sensitivity and the False Discovery Rate of an approach
implemeted by the main functions of adapt4pv package.
}
\examples{

set.seed(15)
drugs <- matrix(rbinom(100*20, 1, 0.2), nrow = 100, ncol = 20)
colnames(drugs) <- paste0("drugs",1:ncol(drugs))
ae <- rbinom(100, 1, 0.3)
lcv <- lasso_cv(x = drugs, y = ae, nfolds = 3)
summary_stat(object = lcv, true_pos = colnames(drugs)[1:10])
# the data are not simulated in such a way that there are true positives


}
\author{
Emeline Courtois \cr Maintainer: Emeline Courtois
\email{emeline.courtois@inserm.fr}
}
