% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movements.R
\name{simplifyMovements}
\alias{simplifyMovements}
\title{Removes invalid events}
\usage{
simplifyMovements(movements, discard.first, tag, bio, speed.method, dist.mat)
}
\arguments{
\item{movements}{the movement dataframe for the tag being analysed.}

\item{discard.first}{A threshold amount of time (in hours) that must pass after
release for the respective detections to be valid. Set to 0 to discard only
the release-to-first-detection calculations.}

\item{tag}{The tag ID of the animal currently being analysed}

\item{bio}{The biometrics table.}

\item{speed.method}{Can take two forms: 'last to first' or 'last to last'.
If 'last to first' (default), the last detection on the previous array is matched
to the first detection on the target array to perform the calculations.
If 'last to last', the last detection on ´the previous array is matched to the
last detection on the target array to perform the calculations.}

\item{dist.mat}{A matrix of the distances between the deployed ALS.}
}
\value{
The movement data frame containing only valid events for the target tag.
}
\description{
Remove invalid movement events and recalculate times/speeds.
}
\keyword{internal}
