\name{ex0.dag.data}
     \docType{data}
     \alias{ex0.dag.data}
     
     \title{Synthetic data set for use with abn library examples}
     \description{300 observations simulated from a DAG with 10 binary variables, 10 gaussian variables and 10 poisson variables.
     }
     \usage{ex0.dag.data} 
\format{A data frame, binary variables are factors. The relevant formulas are given below (note these do not give parameter estimates just the form of the relationships, e.g. logit()=1 means a logit link function and comprises of only an intercept term).

     \describe{
     \item{b1}{binary, logit()=1 }
     \item{b2}{binary, logit()=1 }
     \item{b3}{binary, logit()=1 }
     \item{b4}{binary, logit()=1 }
     \item{b5}{binary, logit()=1 }
     \item{b6}{binary, logit()=1 }
     \item{b7}{binary, logit()=1 }
     \item{b8}{binary, logit()=1 }
     \item{b9}{binary, logit()=1 }
     \item{b10}{binary, logit()=1 }
     \item{g1}{gaussian, identity()=1 }
     \item{g2}{gaussian, identity()=1 }
     \item{g3}{gaussian, identity()=1 }
     \item{g4}{gaussian, identity()=1 }
     \item{g5}{gaussian, identity()=1 }
     \item{g6}{gaussian, identity()=1 }
     \item{g7}{gaussian, identity()=1 }
     \item{g8}{gaussian, identity()=1 }
     \item{g9}{gaussian, identity()=1 }
     \item{g10}{gaussian, identity()=1 }
     \item{p1}{poisson, log()=1 }
     \item{p2}{poisson, log()=1 }
     \item{p3}{poisson, log()=1 }
     \item{p4}{poisson, log()=1 }
     \item{p5}{poisson, log()=1 }
     \item{p6}{poisson, log()=1 }
     \item{p7}{poisson, log()=1 }
     \item{p8}{poisson, log()=1 }
     \item{p9}{poisson, log()=1 }
     \item{p10}{poisson, log()=1 }
     }}
   
\examples{
\dontrun{
## This data set was generated using the following code:
 datasize<-300;
tmp<-c(rep("y",as.integer(datasize/2)),rep("n",as.integer(datasize/2)));
set.seed(1);

ex0.dag.data<-data.frame(b1=sample(tmp,size=datasize,replace=TRUE),
                b2=sample(tmp,size=datasize,replace=TRUE),
                b3=sample(tmp,size=datasize,replace=TRUE),
                b4=sample(tmp,size=datasize,replace=TRUE),
                b5=sample(tmp,size=datasize,replace=TRUE),
                b6=sample(tmp,size=datasize,replace=TRUE),
                b7=sample(tmp,size=datasize,replace=TRUE),
                b8=sample(tmp,size=datasize,replace=TRUE),
                b9=sample(tmp,size=datasize,replace=TRUE),
                b10=sample(tmp,size=datasize,replace=TRUE),
                g1=rnorm(datasize,mean=0,sd=1),
                g2=rnorm(datasize,mean=0,sd=1),
                g3=rnorm(datasize,mean=0,sd=1),
                g4=rnorm(datasize,mean=0,sd=1),
                g5=rnorm(datasize,mean=0,sd=1),
                g6=rnorm(datasize,mean=0,sd=1),
                g7=rnorm(datasize,mean=0,sd=1),
                g8=rnorm(datasize,mean=0,sd=1),
                g9=rnorm(datasize,mean=0,sd=1),
                g10=rnorm(datasize,mean=0,sd=1),
                p1=rpois(datasize,lambda=10),
                p2=rpois(datasize,lambda=10),
                p3=rpois(datasize,lambda=10),
                p4=rpois(datasize,lambda=10),
                p5=rpois(datasize,lambda=10),
                p6=rpois(datasize,lambda=10),
                p7=rpois(datasize,lambda=10),
                p8=rpois(datasize,lambda=10),
                p9=rpois(datasize,lambda=10),
                p10=rpois(datasize,lambda=10)
                );
}}
     
\keyword{datasets}
