% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichmentNetwork.R
\name{plotPathClusters}
\alias{plotPathClusters}
\title{aPEAR enrichment network}
\usage{
plotPathClusters(
  enrichment,
  sim,
  clusters,
  theme = aPEAR.theme,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{enrichment}{a data.frame containing enrichment results}

\item{sim}{similarity matrix of the enriched pathways}

\item{clusters}{clusters of the enriched pathways}

\item{theme}{object of class \code{aPEAR.theme.config}}

\item{verbose}{enable / disable log messages}

\item{...}{additional parameters (see \code{?aPEAR.theme})}
}
\value{
a \code{ggplot2} object
}
\description{
Creates enrichment network plot.
}
\examples{
\donttest{
# Load libraries
library(clusterProfiler)
library(DOSE)
library(org.Hs.eg.db)
data(geneList)

# Perform enrichment using clusterProfiler
enrich <- gseGO(geneList, OrgDb = org.Hs.eg.db, ont = 'CC')

# Obtain clusters within the enriched pathways using default parameters
data <- findPathClusters(enrich@result)

# Create the enrichment network visualization using default parameters
plotPathClusters(enrich@result, data$sim, data$clusters)

# Create the enrichment network visualization with repelled labels and elipses
plotPathClusters(enrich@result, data$sim, data$clusters, repelLabels = TRUE, drawEllipses = TRUE)
}

}
