% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aGE_joint.r
\name{aGE.joint}
\alias{aGE.joint}
\title{aGE joint test}
\usage{
aGE.joint(Y, G, cov = NULL, model = c("gaussian", "binomial"),
  pow = c(1:6), n.perm = 1000, method = c("Simulation"),
  nonparaE = F, DF = 10)
}
\arguments{
\item{Y}{a numeric vector of phenotype values}

\item{G}{a matrix or data frame for all RVs in the test gene or genomic region. The order of rows must match the order of Y. Missing is imputed as 0.}

\item{cov}{a matrix or data frane with first column as the environmental variable to be tested. The order of rows must match the order of Y.}

\item{model}{"binomial" for binary traits or "gaussian" for quantitative traits.}

\item{pow}{Gamma set used to build a family of tests, default=c(1:6) for rare variants}

\item{n.perm}{number of simulation to calculate the p-values, default=1000. Can increase to higher value depending on the signficiance level.}

\item{method}{'Simulation': Monte Carlo Method}

\item{nonparaE}{"T": use cubic splines for the environmental variable to fit the model; "F": use a linear function of the environmental variable to fit the model}

\item{DF}{degree of freedom to use in the cubic splines, default=10. This option only works when nonparaE is set to "T".}
}
\value{
p-values
}
\description{
aGE joint test
}
\examples{
{
 set.seed(12345)
 phenotype <- c(rep(1,50),rep(0,50))
 genotype <- data.frame(g1=sample(c(rep(1,10),rep(0,90))),g2=sample(c(rep(1,5), rep(0,95))))
 covariates <- data.frame(Envir=rnorm(100), Age=rnorm(100,60,5))
 exD <- list(Y=phenotype, G=genotype, X=covariates)
 aGE.joint(Y=exD$Y, G=exD$G, cov=exD$X, model='binomial') 
 }
}
