% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HISCentral_GetSeriesCatalog.R
\name{HISCentral_GetSeriesCatalog}
\alias{HISCentral_GetSeriesCatalog}
\title{HISCentral_GetSeriesCatalog}
\usage{
HISCentral_GetSeriesCatalog(
  west,
  south,
  east,
  north,
  serviceID = NULL,
  keyword = NULL,
  beginDate = NULL,
  endDate = NULL
)
}
\arguments{
\item{west}{The west longitude of the geographic
bounding box in decimal degrees. Allowed values are between -180.0 and +180.0}

\item{south}{The south latitude of the geographic
bounding box in decimal degrees. Allowed values are between -90.0 and +90.0}

\item{east}{The east longitude of the geographic
bounding box in decimal degrees. Allowed values are between -180.0 and +180.0}

\item{north}{The north latitude of the geographic
bounding box in decimal degrees. Allowed values are between -90.0 and +90.0}

\item{serviceID}{(optional): The ID of the service on HIS Central. To get the service ID,
use the id column in the output of the GetServices() function.}

\item{keyword}{(optional): The concept keyword (common name of variable) for
searching the sites on HIS Central. Examples include Temperature, Precipitation, Snow Depth,... If the Keyword is not
specified then sites with any variable will be returned.}

\item{beginDate}{(optional): The begin date of the observations in yyyy-mm-dd format.}

\item{endDate}{(optional): The end date of the observations in yyyy-mm-dd format.}
}
\value{
a data.frame of series catalog entries. The data.frame has the following columns:
\itemize{
\item ServiceCode: The code of the HydroServer
\item ServiceURL: The URL of the server. Use this as the server parameter in GetValues() function.
\item FullSiteCode: The complete unique code of the site in the format NETWORK:CODE.
              Use this value as the siteCode parameter in the GetValues function.
\item FullVariableCode: The complete unique code of the site in the format VOCABULARY:CODE.
              Use this value as the variableCode parameter in the GetValues function.
\item BeginDateTime: The local date/time of the first observation of the time series in POSIXct format.
\item EndDateTime: The local date/time of the last observation of the time series in POSIXct format.
\item ValueCount: The number of measurements in the time series
\item SiteName: The name of the site.
\item Latitude:  The WGS84 latitude of the site in decimal degrees
\item Longitude: The WGS84 longitude of the site in decimal degrees
\item DataType: The data type of the variable
\item ValueType: The type of the observation (field observation, sample, or derived value)
\item SampleMedium: The sample medium (air, water or other)
\item TimeUnits: The time units
\item TimeSupport: The length of the time period of one measurement
}
}
\description{
This function searches the table of time series from the HIS Central catalog
}
\examples{
#Getting all time series from the (14.1E, 49.9N, 14.3E, 50.1N) bounding box
series_catalog <- HISCentral_GetSeriesCatalog(west=14.1, south=49.9, east=14.3, north=50.1)
}
\keyword{waterml}
