% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting.R
\name{align_msg}
\alias{align_msg}
\title{Aligns samples to a specific message.}
\usage{
align_msg(data, Msg = NULL)
}
\arguments{
\item{data}{A data table object output from \code{prep_data}.}

\item{Msg}{An obligatory string containing the exact message to be found in 
the column SAMPLE_MESSAGE.}
}
\value{
A data table object.
}
\description{
\code{align_msg} examines the data from each recording event and locates the
first instance of the specified message in the column SAMPLE_MESSAGE.
The function creates a new column containing the aligned series which can be 
utilized by subsequent functions for checking and creating the time series
column.
}
\examples{
\dontrun{
# To align the samples to a specifc message...
library(VWPre)
df <- align_msg(data = dat, Msg = "ExperimentDisplay")
}
}
