% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GISfuncs.R
\name{GridRefConvert}
\alias{GridRefConvert}
\title{Convert between British National Grid Reference (BNG) and Latitude and Longitude.}
\usage{
GridRefConvert(x, fromBNG = TRUE)
}
\arguments{
\item{x}{A vector of length 2. Either latitude and longitude (if fromBNG = FALSE) or easting and northing (if fromBNG = TRUE).}

\item{fromBNG}{A logical argument with a default of TRUE. When TRUE it converts from easting and northing to latitude and longitude. When FALSE it converts from latitude and longitude to easting and northing.}
}
\value{
A data.frame with the converted grid references. Either latitude and longitude if BNG = TRUE. Or easting and northing if fromBNG = FALSE.
}
\description{
Function to convert between BNG easting & northing and Latitude & Longitude (or vice versa).
}
\examples{
#Get Latitude and Longitude for a BNG numeric reference.
GridRefConvert(c(462899, 187850))
#Now we'll get easting and northing as a function of latitude and longitude
GridRefConvert(c(51.6, -1), fromBNG = FALSE)
}
\author{
Anthony Hammond
}
