% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{DDF13}
\alias{DDF13}
\title{DDF13 results from a DDF13Import object}
\usage{
DDF13(x, duration, RP = 100)
}
\arguments{
\item{x}{A data frame of DDF13 results imported using the DDF13Import functions}

\item{duration}{the duration (hrs) for which a rainfall depth estimate is required}

\item{RP}{the return period (years) for which a rainfall depth estimate is required}
}
\value{
A DDF13 estimate of rainfall depth (mm)
}
\description{
Extracts results from a data frame imported using the DDF13Import function
}
\details{
The .xml files only provide a set number of durations and return periods for DDF13.
This function optimises the GEV distribution on the results in order to interpolate
across return periods. A linear interpolation is used between durations.
The interpolation method may provide results that differ from the FEH webserver in the region of 0.1mm.
The result is then rounded to an integer.
}
\examples{
#Get DDF13 results from a the DDF
\dontrun{DDF13.4003 <- DDF13Import("C:/Data/NRFAPeakFlow_v9/Suitable for QMED/04003.xml")}
#Estimate the 20-year, 5 hour depth
\dontrun{DDF13(DDF13.4003, duration = 5, RP = 20)}
}
\author{
Anthony Hammond
}
