% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XenaHub-class.R
\name{XenaHub}
\alias{XenaHub}
\title{Generate a XenaHub Object}
\usage{
XenaHub(
  hosts = xena_default_hosts(),
  cohorts = character(),
  datasets = character(),
  hostName = c("publicHub", "tcgaHub", "gdcHub", "icgcHub", "toilHub", "pancanAtlasHub",
    "treehouseHub", "pcawgHub", "atacseqHub", "singlecellHub", "kidsfirstHub")
)
}
\arguments{
\item{hosts}{a character vector specify UCSC Xena hosts, all available hosts can be
found by \code{xena_default_hosts()} function. \code{hostName} is a more recommend option.}

\item{cohorts}{default is empty character vector, all cohorts will be returned.}

\item{datasets}{default is empty character vector, all datasets will be returned.}

\item{hostName}{name of host, available options can be accessed by \code{.xena_hosts}
This is an easier option for user than \code{hosts} option. Note, this option
will overlap \code{hosts}.}
}
\value{
a \link{XenaHub} object
}
\description{
It is used to generate original
\code{XenaHub} object according to hosts, cohorts, datasets or hostName.
If these arguments not specified, all hosts and corresponding datasets
will be returned as a \code{XenaHub} object. All datasets can be found
at \url{https://xenabrowser.net/datapages/}.
}
\examples{
\dontrun{
#1 query all hosts, cohorts and datasets
xe = XenaHub()
xe
#2 query only TCGA hosts
xe = XenaHub(hostName = "tcgaHub")
xe
hosts(xe)     # get hosts
cohorts(xe)   # get cohorts
datasets(xe)  # get datasets
samples(xe)   # get samples
}
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
