% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_tweets.R
\name{filter_tweets}
\alias{filter_tweets}
\title{Filter tweets}
\usage{
filter_tweets(data, keywords, include = TRUE)
}
\arguments{
\item{data}{Data frame of parsed tweets. Obtained either by using \code{\link{load_tweets}}  or
\code{\link[jsonlite]{stream_in}} in conjunction with \code{\link[rtweet]{tweets_with_users}}.}

\item{keywords}{Character string of keywords for black- or whitelisting provided via a comma separated character string.}

\item{include}{Logical. Indicate where to perform exclusive or inclusive filtering.
Inclusive filtering is akin to whitelisting keywords. Exclusive filtering is blacklisting certain keywords.}
}
\value{
Data frame of Tweets containing specified keywords
}
\description{
Filter tweets by keywords.
}
\details{
Use this function if you want your Tweets to contain certain keywords.
This can be used for iterative filtering to create more coherent topic models.
Keyword filtering is always case insensitive (lowercase).
}
\examples{

\dontrun{

library(Twitmo)


# load tweets (included in package)
mytweets <- load_tweets(system.file("extdata", "tweets_20191027-141233.json", package = "Twitmo"))

# Exclude Tweets that mention "football" and/or "mood"
keyword_dict <- "football,mood"
mytweets_reduced <- filter_tweets(mytweets, keywords = keyword_dict, include = FALSE)
}
}
