% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.Tenv.R
\name{summary.Tenv}
\alias{summary.Tenv}
\alias{print.summary.Tenv}
\title{Summarize method for Tenv object.}
\usage{
\method{summary}{Tenv}(object, ...)

\method{print}{summary.Tenv}(x, ...)
}
\arguments{
\item{object}{An object of class \code{"Tenv"}, as from \code{\link{TPR.fit}} or \code{\link{TRR.fit}}.}

\item{...}{Arguments to be passed to or from other methods.}

\item{x}{An object of class "summary.Tenv", usually, a result of a call to summary.Tenv.}
}
\value{
Return \code{object} with additional components
 \item{call}{The method call}
 \item{n}{Sample size}
 \item{xdim}{Dimensions of predictor}
 \item{ydim}{Dimensions of response}
 \item{coefficients}{The tensor coefficients estimated from \code{TPR.fit} or \code{TRR.fit}}
 \item{residuals}{The residuals, which equals to the response minus the fitted values}
 \item{Gamma}{A list of envelope subspace basis}
 \item{mse}{Mean squared error. The mean squared Frobenius norm of the difference between each response \eqn{\mathbf{Y}_i} and fitted value \eqn{\hat{\mathbf{Y}}_i},
   \deqn{1/n\sum_{i=1}^n\|\mathbf{Y}_i-\hat{\mathbf{Y}}_i\|_F^2}
 }
 \item{p_val}{Only for object returned from \code{TRR.fit}, p-value for coefficients}
 \item{se}{Only for object returned from \code{TRR.fit}, standard error for coefficients}
}
\description{
Summary method for object returned from \code{TRR.fit} and \code{TPR.fit} functions.
}
\details{
Extract \code{call}, \code{coefficients}, \code{residuals}, \code{Gamma} from \code{object}.

The mean squared error \code{mse} is defined as \eqn{1/n\sum_{i=1}^n\|\mathbf{Y}_i-\hat{\mathbf{Y}}_i\|_F^2}, where \eqn{\hat{\mathbf{Y}}_i} is the prediction and \eqn{\|\cdot\|_F} is the Frobenius norm of tensor.

For the object returned from \code{TRR.fit}, return the \eqn{p}-value and the standard error of estimated coefficient. However, since \eqn{p}-value and standard error depend on \eqn{\widehat{\mathrm{cov}}^{-1}\{\mathrm{vec}(\mathbf{X})\}} which is unavailable for the ultra-high dimensional \eqn{\mathrm{vec}(\mathbf{X})} in tensor predictor regression (TPR), the two statistics are not provided for the object returned from \code{TPR.fit}.

print.summary.Tenv gives a more readable format of the statistics contained in \code{summary.Tenv}. If \code{object} is from \code{\link{TRR.fit}}, then \code{p-val} and \code{se} are also returned.
}
\examples{
data("bat")
x <- bat$x
y <- bat$y
fit <- TRR.fit(x, y, method="standard")
##print summary
summary(fit)
}
\seealso{
\code{\link{Tenv_Pval}} is used to calculate the \eqn{p}-value and standard error.

\code{\link{PMSE}} is used to calculate mean squared error for any provided datasets and coefficient.

Fitting functions \code{\link{TRR.fit}}, \code{\link{TPR.fit}}.
}
