% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func.R
\name{MatrixModel}
\alias{MatrixModel}
\title{Implements the matrix model in Promislow et al (1999)}
\usage{
MatrixModel(mismatch, len, nsolo, r = 0.013, plotFit = FALSE,
  main = sprintf("n = \%d", n))
}
\arguments{
\item{mismatch}{A vector containing the number of mismatches.}

\item{len}{A vector containing the length of each element.}

\item{nsolo}{An integer giving the number of solo elements.}

\item{r}{Mutation rate (substitutions/(million year * site)) used in the calculation.}

\item{plotFit}{Whether to plot the distribution fits.}

\item{main}{The title for the plot.}
}
\value{
This function returns various parameter estimates described in Promislow et al. (1999), containing the following fields. The unit for time is million years ago (Mya):
\item{B}{The constant insertion rate}
\item{q}{The constant excision rate}
\item{lam}{The population growth rate}
\item{R}{The ratio of the number of elements in class j over class j+1, which is constant by assumption}
\item{age1}{The age of the system under model 1 (lambda > 1)}
\item{age2}{The age of the system under model 2 (an initial burst followed by stasis lambda = 1)}
}
\description{
Implements the matrix model in Promislow et al (1999)
}
\details{
For the method implemented see References.
}
\examples{
# Analyze Gypsy family 24 (Nusif)
data(AetLTR)
dat <- subset(AetLTR, GroupID == 24 & !is.na(Chr))
res1 <- MatrixModel(dat$Mismatch, dat$UngapedLen, nsolo=450, plotFit=TRUE)
}
\references{
\cite{Promislow, D., Jordan, K. and McDonald, J. "Genomic demography: a life-history analysis of transposable element evolution." Proceedings of the Royal Society of London B: Biological Sciences 266, no. 1428 (1999): 1555-1560.}
}
