% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmri_ts_forecast.R
\name{fmri_ts_forecast}
\alias{fmri_ts_forecast}
\title{forecast the fMRI data based on the time series}
\usage{
fmri_ts_forecast(fmridata, voxel_location, cut = 10)
}
\arguments{
\item{fmridata}{a 4D array contains information for the fMRI spacetime image. The data should only contain the magnitude for the fMRI image.}

\item{voxel_location}{a 3d array indicating the voxel location of the brain}

\item{cut}{breaking point of the time-series data. The default is 10.}
}
\value{
a figure forecasting the fMRI voxel with time series
}
\description{
a function to forecast the fMRI data based on the time series
}
\details{
The function \code{fmri_ts_forecast} is used to forecast with time series. It will fit the best ARIMA model to univariate time series from the input fMRI data.
}
\examples{
fmri_generate = fmri_simulate_func(dim_data = c(64, 64, 40), mask = mask)
\donttest{
smoothmod <- GaussSmoothArray(fmri_generate$fmri_data, sigma = diag(3,3))
fmri_ts_forecast(smoothmod,c(41,44,33))
}
}
\author{
SOCR team <\url{http://socr.umich.edu/people/}>
}
