% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IBS.R
\name{IBS}
\alias{IBS}
\title{IBS}
\usage{
IBS(object, sp_matrix, IBSrange = range(object[, 1]))
}
\arguments{
\item{object}{object of class \code{Surv} in the testing set created by Surv function.}

\item{sp_matrix}{a matrix or data.frame of predicted values of survival probabilities for the testing set.}

\item{IBSrange}{a vector contains all discrete time points corresponding to the predicted probability in sp_matrix.
Or the scale you want to get the IBS; and if it is a single point the return value will be the Brier Score at the timepoint.}
}
\value{
The integration of brierscore
}
\description{
IBS is  an integrated version of the Brier which is used to calculate the integration of the Brier Score.
The Brier Score is the mean square difference between the true classes and the predicted probabilities.
Basically, the IBS is an integrated
weighted squared distance between the estimated survival function and the empirical
survival function. The inverse probability censoring weighting(IPCW) is used to adjust for censoring.
}
\details{
The percentage of censored observations increases in time, and this will surely affect the dispersion of the empirical Brier Score.
The question of how censoring in finite samples acts on the distribution of our measures of inaccuracy is an interesting subject.
Our recommendation is to choose t* in a way that censoring is not too heavy (for example, the median follow-up time).
We also prefer measures with integrated loss functions since they will reflect inaccuracy over an interval rather than just at one point in time.
In addition, the corresponding empirical measures are likely to have lower dispersion, because censored observations contribute their estimated event-free probabilities to the integrand until the censoring occurs.
}
\examples{
library(randomForestSRC)
library(survival)
library(SurvMetrics)
set.seed(123)
N = 100
mydata = SDGM4(N, p = 20, c_step = -0.5)
index.train = sample(1:N,2/3*N)
data.train = mydata[index.train,]
data.test = mydata[-index.train,]

fit.RSF = rfsrc(Surv(time,status)~.,data.train,nsplit=3,ntree=500)
predicted = predict(fit.RSF,data.test)
sp_matrix = predicted$survival

object = Surv(data.test$time,data.test$status)

#the default time points
IBS(object, sp_matrix, predicted$time.interest)
#a time range
IBS(object,sp_matrix,c(18:100))


}
\references{
HooraMoradian, DenisLarocque, & FranoisBellavance. (2017). \\(l_1\\) splitting rules in survival forests. Lifetime Data Analysis, 23(4), 671–691.

Graf, Erika, Schmoor, Claudia, Sauerbrei, & Willi, et al. (1999). Assessment and comparison of prognostic classification schemes for survival data. Statist. Med., 18(1718), 2529-2545.

Brier, G. W. . (1950). Verification of forecasts expressed in terms of probability. Monthly Weather Review, 78.

Gneiting, T. , &  Raftery, A. E. . (2007). Strictly Proper Scoring Rules, Prediction, and Estimation.
}
\author{
Hanpu Zhou \email{zhouhanpu@csu.edu.cn}
}
