% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaAnalyticSurvBin.R
\name{print.MetaAnalyticSurvBin}
\alias{print.MetaAnalyticSurvBin}
\title{Prints all the elements of an object fitted with the 'MetaAnalyticSurvBin()' function.}
\usage{
\method{print}{MetaAnalyticSurvBin}(x, ...)
}
\arguments{
\item{x}{An object of class 'MetaAnalyticSurvBin' fitted with the 'MetaAnalyticSurvBin()' function.}

\item{...}{...}
}
\value{
The surrogacy measures with their 95\% confidence intervals and the estimated treament effect on the surrogate and true endpoint.
}
\description{
Prints all the elements of an object fitted with the 'MetaAnalyticSurvBin()' function.
}
\examples{
\dontrun{
data("colorectal")
fit_bin <- MetaAnalyticSurvBin(data = colorectal, true = surv, trueind = SURVIND,
                               surrog = responder, trt = TREAT, center = CENTER,
                               trial = TRIAL, patientid = patientid,
                               adjustment="unadjusted")
print(fit_bin)
}
}
