% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaAnalyticSurvCont.R
\name{MetaAnalyticSurvCont}
\alias{MetaAnalyticSurvCont}
\title{Compute surrogacy measures for a continuous (normally-distributed) surrogate and a time-to-event true endpoint in the meta-analytic multiple-trial setting.}
\usage{
MetaAnalyticSurvCont(
  data,
  true,
  trueind,
  surrog,
  trt,
  center,
  trial,
  patientid,
  copula,
  adjustment
)
}
\arguments{
\item{data}{A data frame with the correct columns (See Data Format).}

\item{true}{Observed time-to-event for true endpoint.}

\item{trueind}{Time-to-event indicator for the true endpoint.}

\item{surrog}{Continuous surrogate endpoint.}

\item{trt}{Treatment indicator.}

\item{center}{Center indicator (equal to trial if there are no different centers). This is the unit for which specific treatment effects are estimated.}

\item{trial}{Trial indicator. This is the unit for which common baselines are to be used.}

\item{patientid}{Patient indicator.}

\item{copula}{The copula that is used, either "Clayton", "Hougaard" or "Plackett"}

\item{adjustment}{The adjustment that should be made for the trial-level surrogacy, either "unadjusted", "weighted" or "adjusted"}
}
\value{
Returns an object of class "MetaAnalyticSurvCont" that can be used to evaluate surrogacy and contains the following elements:
\itemize{
\item Indiv.Surrogacy: a data frame that contains the measure for the individual level surrogacy and 95\% confidence interval.
\item Trial.R2: a data frame that contains the \eqn{R^2_{trial}} and 95\% confidence interval to evaluate surrogacy at the trial level.
\item EstTreatEffects: a data frame that contains the estimated treatment effects and sample size for each trial.
\item nlm.output: output of the maximization procedure (nlm) to maximize the likelihood.
}
}
\description{
The function 'MetaAnalyticSurvCont()' fits the model for a continuous surrogate and time-to-event true endpoint described by Alonso et al. (2016) in the meta-analytic multiple-trial setting.
}
\section{Model}{
In the model, a copula-based model is used for the true time-to-event endpoint and the surrogate continuous, normally distributed endpoint.
More specifically, three copulas can be used: the Clayton copula, Hougaard copula and Plackett copula. The marginal model for the true endpoint is the proportional hazard model.
The marginal model for the surrogate endpoint is the classical linear regression model.
The quality of the surrogate at the individual level can be evaluated by either Kendall's \eqn{\tau} or Spearman's \eqn{\rho}, depending on which copula function is used.
The quality of the surrogate at the trial level can be evaluated by considering the \eqn{R^2_{trial}} between the estimated treatment effects.
}

\section{Data Format}{
The data frame must contains the following columns:
\itemize{
\item a column with the observed time-to-event for the true endpoint
\item a column with the time-to-event indicator for the true endpoint: 1 if the event is observed, 0 otherwise
\item a column with the continuous surrogate endpoint
\item a column with the treatment indicator: 0 or 1
\item a column with the trial indicator
\item a column with the center indicator. If there are no different centers within each trial, the center indicator is equal to the trial indicator
\item a column with the patient indicator
}
}

\examples{
\dontrun{
data("prostate")
fit <- MetaAnalyticSurvCont(data = prostate, true = SURVTIME, trueind = SURVIND, surrog = PSA,
trt = TREAT, center = TRIAL, trial = TRIAL, patientid = PATID,
copula = "Hougaard", adjustment = "weighted")
summary(fit)
print(fit)
plot(fit)
}
}
\references{
Alonso A, Bigirumurame T, Burzykowski T, Buyse M, Molenberghs G, Muchene L, Perualila NJ, Shkedy Z, Van der Elst W, et al. (2016). Applied surrogate endpoint evaluation methods with SAS and R. CRC Press New York
}
\author{
Dries De Witte
}
