% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SL.glm.R
\name{SL.glm}
\alias{SL.glm}
\title{Wrapper for glm}
\usage{
SL.glm(Y, X, newX, family, obsWeights, model = TRUE, ...)
}
\arguments{
\item{Y}{Outcome variable}

\item{X}{Training dataframe}

\item{newX}{Test dataframe}

\item{family}{Gaussian or binomial}

\item{obsWeights}{Observation-level weights}

\item{model}{Whether to save model.matrix of data in fit object. Set to FALSE
to save memory.}

\item{...}{Any remaining arguments, not used.}
}
\description{
Wrapper for generalized linear models via glm().

Note that for outcomes bounded by [0, 1] the binomial family can be used in
addition to gaussian.
}
\examples{

data(Boston, package = "MASS")
Y = Boston$medv
# Remove outcome from covariate dataframe.
X = Boston[, -14]

set.seed(1)

sl = SuperLearner(Y, X, family = gaussian(),
                  SL.library = c("SL.mean", "SL.glm"))

print(sl)

}
\references{
Fox, J. (2015). Applied regression analysis and generalized linear models.
Sage Publications.
}
\seealso{
\code{\link{predict.SL.glm}} \code{\link[stats]{glm}}
  \code{\link[stats]{predict.glm}}  \code{\link{SL.speedglm}}
}
