% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighbourhood.R
\docType{methods}
\name{wrap}
\alias{wrap}
\alias{wrap,matrix,Extent,missing-method}
\alias{wrap,SpatialPoints,ANY,missing-method}
\alias{wrap,matrix,Raster,missing-method}
\alias{wrap,matrix,Raster,missing-method}
\alias{wrap,matrix,matrix,missing-method}
\alias{wrap,SpatialPointsDataFrame,Extent,logical-method}
\alias{wrap,SpatialPointsDataFrame,Raster,logical-method}
\alias{wrap,SpatialPointsDataFrame,matrix,logical-method}
\title{Wrap coordinates or pixels in a torus-like fashion}
\usage{
wrap(X, bounds, withHeading)

\S4method{wrap}{matrix,Extent,missing}(X, bounds)

\S4method{wrap}{SpatialPoints,ANY,missing}(X, bounds)

\S4method{wrap}{matrix,Raster,missing}(X, bounds)

\S4method{wrap}{matrix,Raster,missing}(X, bounds)

\S4method{wrap}{matrix,matrix,missing}(X, bounds)

\S4method{wrap}{SpatialPointsDataFrame,Extent,logical}(X, bounds, withHeading)

\S4method{wrap}{SpatialPointsDataFrame,Raster,logical}(X, bounds, withHeading)

\S4method{wrap}{SpatialPointsDataFrame,matrix,logical}(X, bounds, withHeading)
}
\arguments{
\item{X}{A \code{SpatialPoints*} object, or matrix of coordinates.}

\item{bounds}{Either a \code{Raster*}, \code{Extent}, or \code{bbox} object
defining bounds to wrap around.}

\item{withHeading}{logical. If \code{TRUE}, the previous points must be wrapped
also so that the subsequent heading calculation will work.
Default \code{FALSE}. See details.}
}
\value{
Object of the same class as \code{X}, but with coordinates updated to
        reflect the wrapping.
}
\description{
Generally useful for model development purposes.
}
\details{
If \code{withHeading} used, then \code{X} must be a \code{SpatialPointsDataFrame}
that contains two columns, \code{x1} and \code{y1}, with the immediately
previous agent locations.
}
\examples{
library(raster)
library(quickPlot)

xrange <- yrange <- c(-50, 50)
hab <- raster(extent(c(xrange, yrange)))
hab[] <- 0

# initialize agents
N <- 10

# previous points
x1 <- rep(0, N)
y1 <- rep(0, N)
# initial points
starts <- cbind(x = stats::runif(N, xrange[1], xrange[2]),
                y = stats::runif(N, yrange[1], yrange[2]))

# create the agent object
agent <- SpatialPointsDataFrame(coords = starts, data = data.frame(x1, y1))


ln <- rlnorm(N, 1, 0.02) # log normal step length
sd <- 30 # could be specified globally in params

if (interactive()) {
  clearPlot()
  Plot(hab, zero.color = "white", axes = "L")
}
for (i in 1:10) {
  agent <- crw(agent = agent, extent = extent(hab), stepLength = ln,
               stddev = sd, lonlat = FALSE, torus = TRUE)
  if (interactive()) Plot(agent, addTo = "hab", axes = TRUE)
}
}
\author{
Eliot McIntire
}
