% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation-simInit.R
\name{simInitAndSpades}
\alias{simInitAndSpades}
\title{Call \code{simInit} and \code{spades} together}
\usage{
simInitAndSpades(
  times,
  params,
  modules,
  objects,
  paths,
  inputs,
  outputs,
  loadOrder,
  notOlderThan,
  debug,
  progress,
  cache,
  .plotInitialTime,
  .saveInitialTime,
  ...
)
}
\arguments{
\item{times}{A named list of numeric simulation start and end times
(e.g., \code{times = list(start = 0.0, end = 10.0)}).}

\item{params}{A list of lists of the form \code{list(moduleName=list(param1=value, param2=value))}.
See details.}

\item{modules}{A named list of character strings specifying the names of modules to be loaded
for the simulation.
Note: the module name should correspond to the R source file from which the module is loaded.
Example: a module named "caribou" will be sourced form the file \file{caribou.R},
located at the specified \code{modulePath(simList)} (see below).}

\item{objects}{(optional) A vector of object names (naming objects
that are in the calling environment of
the \code{simInit}, which is often the
\code{.GlobalEnv} unless used programmatically.
NOTE: this mechanism will
fail if object name is in a package dependency), or
a named list of data objects to be
passed into the \code{simList} (more reliable).
These objects will be accessible
from the \code{simList} as a normal list, e.g,. \code{mySim$obj}.}

\item{paths}{An optional named list with up to 4 named elements,
\code{modulePath}, \code{inputPath}, \code{outputPath}, and \code{cachePath}.
See details. NOTE: Experimental feature now allows for multiple \code{modulePath}s
to be specified in a character vector. The modules will be searched for sequentially
in the first \code{modulePath}, then if it doesn't find it, in the second etc.}

\item{inputs}{A \code{data.frame}. Can specify from 1 to 6
columns with following column names: \code{objectName} (character, required),
\code{file} (character), \code{fun} (character), \code{package} (character),
\code{interval} (numeric), \code{loadTime} (numeric).
See \code{\link{inputs}} and vignette("ii-modules") section about inputs.}

\item{outputs}{A \code{data.frame}. Can specify from 1 to 5
columns with following column names: \code{objectName} (character, required),
\code{file} (character), \code{fun} (character), \code{package} (character),
\code{saveTime} (numeric) and \code{eventPriority} (numeric). If
\code{eventPriority} is not set, it defaults to \code{.last()}. If \code{eventPriority}
is set to a low value, e.g., 0, 1, 2 and \code{saveTime} is \code{start(sim)},
it should give "initial conditions".

See \code{\link{outputs}} and
\code{vignette("ii-modules")} section about outputs.}

\item{loadOrder}{An optional list of module names specifying the order in
which to load the modules. If not specified, the module
load order will be determined automatically.}

\item{notOlderThan}{A time, as in from \code{Sys.time()}. This is passed into
the \code{Cache} function that wraps \code{.inputObjects}.
If the module uses the \code{.useCache} parameter and it is
set to \code{TRUE} or \code{".inputObjects"},
then the \code{.inputObjects} will be cached.
Setting \code{notOlderThan = Sys.time()} will cause the
cached versions of \code{.inputObjects} to be refreshed,
i.e., rerun.}

\item{debug}{Optional tools for invoking debugging. Supplying a \code{list}
will invoke the more powerful \code{logging} package. See details.
Default is to use the value in \code{getOption("spades.debug")}.}

\item{progress}{Logical (\code{TRUE} or \code{FALSE} show a graphical progress bar),
character (\code{"graphical"}, \code{"text"}) or numeric indicating
the number of update intervals to show in a graphical progress bar.}

\item{cache}{Logical. If \code{TRUE}, then the \code{spades} call will be cached.
This means that if the call is made again with the same simList,
then `spades`` will return the return value from the previous run
of that exact same simList. Default \code{FALSE}. See Details.
See also the vignette on caching for examples.}

\item{.plotInitialTime}{Numeric. Temporarily override the \code{.plotInitialTime}
parameter for all modules. See Details.}

\item{.saveInitialTime}{Numeric. Temporarily override the \code{.plotInitialTime}
parameter for all modules. See Details.}

\item{...}{Arguments passed to simInit and spades}
}
\value{
Same as \code{\link{spades}} (a \code{simList}) or
}
\description{
These functions are convenience wrappers that may allow for
more efficient Caching.
Passes all arguments to \code{simInit}, then passes the created \code{simList}
to \code{spades}.
}
\seealso{
\code{\link{simInit}}, \code{\link{spades}}
}
