% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkpoint.R, R/simList-accessors.R
\docType{methods}
\name{doEvent.checkpoint}
\alias{doEvent.checkpoint}
\alias{checkpointLoad}
\alias{.checkpointSave}
\alias{checkpointFile}
\alias{checkpointFile,simList-method}
\alias{checkpointFile<-}
\alias{checkpointFile<-,simList-method}
\alias{checkpointInterval}
\alias{checkpointInterval,simList-method}
\alias{checkpointInterval<-}
\alias{checkpointInterval<-,simList-method}
\title{Simulation checkpoints.}
\usage{
doEvent.checkpoint(sim, eventTime, eventType, debug = FALSE)

checkpointLoad(file)

.checkpointSave(sim, file)

checkpointFile(sim)

\S4method{checkpointFile}{simList}(sim)

checkpointFile(sim) <- value

\S4method{checkpointFile}{simList}(sim) <- value

checkpointInterval(sim)

\S4method{checkpointInterval}{simList}(sim)

checkpointInterval(sim) <- value

\S4method{checkpointInterval}{simList}(sim) <- value
}
\arguments{
\item{sim}{A \code{simList} simulation object.}

\item{eventTime}{A numeric specifying the time of the next event.}

\item{eventType}{A character string specifying the type of event: one of
either \code{"init"}, \code{"load"}, or \code{"save"}.}

\item{debug}{Optional logical flag determines whether sim debug info
will be printed (default \code{debug = FALSE}).}

\item{file}{The checkpoint file.}

\item{value}{The object to be stored at the slot.}
}
\value{
Returns the modified \code{simList} object.
}
\description{
Save and reload the current state of the simulation,
including the state of the random number generator,
by scheduling checkpoint events.
}
\details{
RNG save code adapted from:
\url{http://www.cookbook-r.com/Numbers/Saving_the_state_of_the_random_number_generator/}
and \url{https://stackoverflow.com/questions/13997444/}
}
\seealso{
\code{\link{.Random.seed}}.

Other functions to access elements of a \code{simList} object: \code{\link{.addDepends}},
  \code{\link{envir}}, \code{\link{events}},
  \code{\link{globals}}, \code{\link{inputs}},
  \code{\link{modules}}, \code{\link{objs}},
  \code{\link{packages}}, \code{\link{params}},
  \code{\link{paths}}, \code{\link{progressInterval}},
  \code{\link{times}}
}
\author{
Alex Chubaty
}
\concept{functions to access elements of a \code{simList} object}
