% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ss.data.density}
\alias{ss.data.density}
\title{Pellets density}
\format{A vector with 24 items for the density of a set of pellets
(\emph{gr/cm}$^3$).}
\source{
Table 1.2 in the reference below.
}
\usage{
data("ss.data.density")
}
\description{
This data set contains the density for 24 pellets.
}
\details{
This data set illustrates concepts in the book ``Quality Control with R''.
Note that, in the book, the vector named \code{pdensity} is directly created
and then used in the examples.
}
\examples{

data(ss.data.density)
str(ss.data.density) 
library(qcc)
qcc(ss.data.density,
    type = "xbar.one")

}
\references{
Cano, E.L. and Moguerza, J.M. and Prieto Corcoba, M. (2015)
\emph{Quality Control with R. An ISO Standards Approach}. Springer.
}
\keyword{datasets}
