% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jmvreli.h.R
\name{jmvreli}
\alias{jmvreli}
\title{Reliability Analysis}
\usage{
jmvreli(data, vars, ciWidth = 95, desc = FALSE, plots = FALSE)
}
\arguments{
\item{data}{the data as a data frame}

\item{vars}{a list of the column names containing the measurements for
reliability analysis.}

\item{ciWidth}{a number between 50 and 99.9 (default: 95), the width of
confidence intervals}

\item{desc}{\code{TRUE} or \code{FALSE} (default), provide table of
variance components}

\item{plots}{\code{TRUE} or \code{FALSE} (default), plot data}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$text} \tab \tab \tab \tab \tab a preformatted \cr
  \code{results$icctab} \tab \tab \tab \tab \tab a table \cr
  \code{results$vartab} \tab \tab \tab \tab \tab a table \cr
  \code{results$plots} \tab \tab \tab \tab \tab an image \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$icctab$asDF}

\code{as.data.frame(results$icctab)}
}
\description{
Reliability Analysis
}
