% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{as.ChromatinAssay}
\alias{as.ChromatinAssay}
\alias{as.ChromatinAssay.Assay}
\title{Convert objects to a ChromatinAssay}
\usage{
as.ChromatinAssay(x, ...)

\method{as.ChromatinAssay}{Assay}(
  x,
  ranges = NULL,
  seqinfo = NULL,
  annotation = NULL,
  motifs = NULL,
  fragments = NULL,
  bias = NULL,
  positionEnrichment = NULL,
  sep = c("-", "-"),
  ...
)
}
\arguments{
\item{x}{An object to convert to class \code{\link{ChromatinAssay}}}

\item{...}{Arguments passed to other methods}

\item{ranges}{A GRanges object}

\item{seqinfo}{A \code{\link[GenomeInfoDb]{Seqinfo}} object containing basic
information about the genome used. Alternatively, the name of a UCSC genome
can be provided and the sequence information will be downloaded from UCSC.}

\item{annotation}{Genomic annotation. It must have the following columns:
\itemize{
  \item{tx_id or transcript_id: Transcript ID}
  \item{gene_name: Gene name}
  \item{gene_id: Gene ID}
  \item{gene_biotype: Gene biotype (e.g. "protein_coding", "lincRNA")}
  \item{type: Annotation type (e.g. "exon", "gap")}
}}

\item{motifs}{A \code{\link{Motif}} object}

\item{fragments}{A list of \code{\link{Fragment}} objects}

\item{bias}{Tn5 integration bias matrix}

\item{positionEnrichment}{A named list of position enrichment matrices.}

\item{sep}{Characters used to separate the chromosome, start, and end
coordinates in the row names of the data matrix}
}
\description{
Convert objects to a ChromatinAssay
}
\concept{assay}
