% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_species_anno_db.R
\name{load_species_anno_db}
\alias{load_species_anno_db}
\title{Load species specific \code{AnnotationDb}}
\usage{
load_species_anno_db(species.name, remove.na.rows = TRUE)
}
\arguments{
\item{species.name}{Species name. Options: human, rat, mouse}

\item{remove.na.rows}{Remove rows with NA in the gene_id column}
}
\value{
Species specific \code{AnnotationDb}
}
\description{
Use \code{AnnotationHub} to load species-specific GTF and 2bit DNA
sequences. This function currently works for human, rat, and mouse.

The function will return:
\itemize{
\item \verb{$gtf}: A \code{GRanges} object containing the GTF information
\item \verb{$tx.db}: A \code{tx.db} object made from the GTF
\item \verb{$dna}: The 2bit DNA sequence as a \code{DNAStringSet}
}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
anno.db = load_species_anno_db("human")
\dontshow{\}) # examplesIf}
}
