% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dstat_histogram.R
\name{dstat_histogram}
\alias{dstat_histogram}
\title{Plot a histogram of dstat statistics from tests provided by the \code{twosamples}
package}
\usage{
dstat_histogram(
  test.results,
  title = "Histogram of Test Statistics",
  line.col = "red"
)
}
\arguments{
\item{test.results}{The twosamples object holding the test stats and
iteration information.}

\item{title}{Title of the plot}

\item{line.col}{Color to use for Dstat line}
}
\value{
ggplot histogram object
}
\description{
This function will take the twosamples object and plot the
histogram of dstats using ggplot.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dplyr)

guide.seq = "UUAUAGAGCAAGAACACUGUUUU"

anno.db = load_species_anno_db("human")

features = get_feature_seqs(anno.db$tx.db, anno.db$dna)

# Load test data
get_example_data("sirna")

sirna.data = load_example_data("sirna")

res <- sirna.data$Schlegel_2022_Ttr_D1_30mkg

# Filter DESeq2 results for SeedMatchR
res = filter_deseq(res, fdr.cutoff=1, fc.cutoff=0, rm.na.log2fc = TRUE)

res = SeedMatchR(res, anno.db$gtf, features$seqs, guide.seq, "mer7m8")

# Gene set 1
mer7m8.list = res$gene_id[res$mer7m8 >= 1]

# Gene set 2
background.list = res$gene_id[!(res$mer7m8 \%in\% mer7m8.list)]

ecdf.res = ecdf_stat_test(res, mer7m8.list, background.list)

hist = dstat_histogram(ecdf.res)
\dontshow{\}) # examplesIf}
}
