% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{add_climatology}
\alias{add_climatology}
\title{Add climatology to a data table}
\usage{
add_climatology(dt, data_cols = NULL, years = NULL, by = dimvars(dt))
}
\arguments{
\item{dt}{the data table.}

\item{data_cols}{For which columns do you want to derive the climatology?
The default i}

\item{years}{The average over which years should be considered as climatology.
The default is all years in dt.}

\item{by}{column names to group by.}
}
\value{
The provided data table with an extra climatology column
}
\description{
The climatology is the average over years (and members for ensemble forecases),
taken separately for each month, season, and coordinate.
By default, the average is taken over all years in the data table,
but you can change this using the years-argument.
By default, climatologies (averages) are calculated for each column that is not
recognized as dimension variable and does not contain characters.
}
\examples{
dt = add_climatology(chirps_monthly)
}
