% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_calibration.R
\name{apply_calibration}
\alias{apply_calibration}
\title{apply_calibration}
\usage{
apply_calibration(stic_data, calibration, outside_std_range_flag = TRUE)
}
\arguments{
\item{stic_data}{A data frame with a column named \code{condUncal}, for example as produced by the function \link{tidy_hobo_data}.}

\item{calibration}{a model object relating \code{condUncal} to a standard of some sort, for example as produced by the function \link{get_calibration}.}

\item{outside_std_range_flag}{a logical argument indicating whether the user would like to include an additional column flagging instances where the calibrated SpC value is outside the range of standards used to calibrate it}
}
\value{
The same data frame as input, except with a new column called \code{SpC}. This will be in the same units as the data used to develop the model calibration.
}
\description{
This function takes the cleaned data frame generated by \code{tidy_hobo_data} and the fitted model object generated by \code{get_calibration}. It outputs a data frame with the same columns as the input, plus a calibrated specific conductivity column called SpC.
}
\examples{
calibration <- get_calibration(calibration_standard_data)
calibrated_df <- apply_calibration(tidy_stic_data, calibration, outside_std_range_flag = TRUE)
head(calibrated_df)

}
