% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hadza.R
\docType{data}
\name{Hadza}
\alias{Hadza}
\title{Hadza hunter-gatherer gut metagenomes}
\format{
A SQM object; see \code{\link{loadSQM}}.
}
\source{
\href{https://www.ncbi.nlm.nih.gov/sra/?term=SRR1927149}{SRR1927149}, \href{https://www.ncbi.nlm.nih.gov/sra/?term=SRR1929485}{SRR1929485}.
}
\usage{
data(Hadza)
}
\description{
Subset of two bins (and the associated contigs and genes)
generated by running SqueezeMeta on two gut metagenomic samples
obtained from two hunter-gatherers of the Hadza ethnic group.
}
\examples{
data(Hadza)
plotTaxonomy(Hadza, "genus", rescale=TRUE)
plotFunctions(Hadza, "COG")

}
\references{
Rampelli \emph{et al.}, 2015. Metagenome Sequencing of the Hadza
Hunter-Gatherer Gut Microbiota. \emph{Curr. biol.} \bold{25}:1682-93
(\href{https://pubmed.ncbi.nlm.nih.gov/25981789/}{PubMed}).
}
\keyword{datasets}
