% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparseness_funcs.R
\name{gini.index}
\alias{gini.index}
\title{Gini index.}
\usage{
gini.index(x, levels = 256)
}
\arguments{
\item{x}{numeric. Peak intensity array.}

\item{levels}{numeric (default = 256). Number of levels for the peak
intensity quantization.}
}
\value{
A value between 0 and 1. High levels of signal sparsity are associated
with values close to 1, whereas low levels of signal sparsity are associated
with values close to 0.
}
\description{
\code{gini.index} returns the Gini index of the ion intensity vector as a
measure of its sparseness. The intensity vector is first quantized in N
levels (default = 256). A value close to 1 represents a high level of
sparseness, a value close to 0 represents a low level of sparseness.
}
\examples{
## Load package
library("SPUTNIK")

## Image
im <- matrix(rnorm(100), 10, 10)

## Spatial chaos
sc <- spatial.chaos(im, levels = 30, morph = TRUE)
stopifnot(sc <= 1)

## Gini index
gi <- gini.index(im, levels = 16)
stopifnot(gi >= -1 && gi <= 1)

## Scatter ratio
sr <- scatter.ratio(im)
stopifnot(sr <= 1)
}
\references{
Hurley, N., & Rickard, S. (2009). Comparing measures of sparsity.
IEEE Transactions on Information Theory, 55(10), 4723-4741.
}
\seealso{
\link{scatter.ratio} \link{spatial.chaos}
}
\author{
Paolo Inglese \email{p.inglese14@imperial.ac.uk}
}
