% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_funcs.R
\name{msiDataset}
\alias{msiDataset}
\title{Constructior for \link{msi.dataset-class} objects.}
\usage{
msiDataset(values, mz, rsize, csize)
}
\arguments{
\item{values}{numeric matrix containing the peaks intensities. Rows represent
pixels and columns represent peaks.}

\item{mz}{array of m/z peaks values.}

\item{rsize}{geometric shape (number of rows) of image.}

\item{csize}{geometric shape (number of columns) of image.}
}
\value{
\link{msi.dataset-class} object.
}
\description{
\code{msiDataset} returns a \link{msi.dataset-class} object. It
containg information about the matched peaks intensities, the geometrical
dimensions of the mass spectral image, the matched m/z values.
}
\details{
Function used to construct the main object \code{\link{msi.dataset-class}}.
This object contains all the information about peaks intensities (intensity
matrix), the geometrical shape of the image (rows, columns), and the vector
of the matched m/z values, generated during the peak matching process.
}
\examples{
## Load package
library("SPUTNIK")

## Create the msi.dataset-class object
sz <- c(5, 4)
x <- matrix(rnorm(sz[1] * sz[2] * 20), sz[1]*sz[2], 20)
mz <- sort(sample(100, ncol(x)))
msiX <- msiDataset(x, mz, sz[1], sz[2])

}
\author{
Paolo Inglese \email{p.inglese14@imperial.ac.uk}
}
