% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sms_emoa.r
\name{spotSmsEmoaKriging}
\alias{spotSmsEmoaKriging}
\title{SMS-EMOA: S-Metric-Selection Evolutionary Multi-objective Optimization Algorithm}
\usage{
spotSmsEmoaKriging(f, lower, upper, ..., control = list(mu = 100L, sbx.n = 15,
  sbx.p = 0.7, pm.n = 25, pm.p = 0.3))
}
\arguments{
\item{f}{target function to be optimized of  type f(x)=y where both x and y are vectors.
The target function should return a vector of length(y) containing NAs if the input vector x contains NA values.}

\item{lower}{the lower boundary vector of the decision space}

\item{upper}{the upper boundary vector of the decision space}

\item{...}{further settings relayed to \code{f}}

\item{control}{list of parameters (defaults are: mu=100L, sbx.n=15, sbx.p=0.7, pm.n=25, pm.p=0.3)}
}
\value{
list with archive of solutions, active Pareto front and others
}
\description{
Straight forward SMS-EMOA implementation, but supported by a Kriging model when selecting new individuals.
}
\seealso{
N. Beume, B. Naujoks, and M.Emmerich. \emph{SMS-EMOA: Multiobjective selection based on dominated hypervolume}.
European Journal of Operational Research, 181(3):1653--1669, 2007. \cr \cr
Link to the sms_emoa code by Olaf Mersmann: \url{http://git.p-value.net/p/emoa.git/tree/examples/sms_emoa.r}
}

