% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp2cell.R
\name{exp2cell}
\alias{exp2cell}
\title{exp2cell}
\usage{
exp2cell(exp, method = "xCell", perm = 100, QN = TRUE)
}
\arguments{
\item{exp}{The gene expression data set. A matrix with row names as symbols and columns as samples.
Gene expression profiles were used to quantify cell abundance matrix.}

\item{method}{Method must be one of "xCell", "ssGSEA" and "CIBERSORT".}

\item{perm}{No. permutations; set to >=100 to calculate p-values (default = 100)}

\item{QN}{Quantile normalization of input mixture (default = TRUE)}
}
\value{
Cell abundance matrix.
}
\description{
Function `exp2cell` use gene expression profiles to quantify cell abundance matrix.
`exp2cell` provides three methods for estimating the relative infiltration abundance of different cell types in the tumor microenvironment (TME),
which including xCell, ssGSEA estimated method proposed by Şenbabaoğlu et al. and CIBERSORT.
}
\examples{
#get breast cancer gene expression profile.
exp.example<-GetExampleData("exp.example")

#perform the exp2cell method. Method must be one of "xCell","ssGSEA" and "CIBERSORT".
cellmatrix<-exp2cell(exp=exp.example,method="ssGSEA") #cell abundance matrix
}
\references{
1. Aaron, M, Newman, et al. Robust enumeration of cell subsets from tissue expression profiles.[J]. Nature Methods, 2015.
2. Aran D , Hu Z , Butte A J . xCell: digitally portraying the tissue cellular heterogeneity landscape[J]. Genome Biology, 2017, 18(1):220.
3. Şenbabaoğlu, Yasin, Gejman R S , Winer A G , et al. Tumor immune microenvironment characterization in clear cell renal cell carcinoma identifies prognostic and immunotherapeutically relevant messenger RNA signatures[J]. Genome biology, 2016, 17(1).
}
