% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{isCaste}
\alias{isCaste}
\alias{isQueen}
\alias{isFather}
\alias{isWorker}
\alias{isDrone}
\alias{isVirginQueen}
\title{Is individual a member of a specific caste}
\usage{
isCaste(x, caste, simParamBee = NULL)

isQueen(x, simParamBee = NULL)

isFather(x, simParamBee = NULL)

isWorker(x, simParamBee = NULL)

isDrone(x, simParamBee = NULL)

isVirginQueen(x, simParamBee = NULL)
}
\arguments{
\item{x}{\code{\link{Pop-class}}}

\item{caste}{character, one of "queen", "fathers", "workers", "drones", or
"virginQueens"; only single value is used}

\item{simParamBee}{\code{\link{SimParamBee}}, global simulation parameters}
}
\value{
logical
}
\description{
Level 0 function that tests if individuals are members of a
  specific caste
}
\section{Functions}{
\itemize{
\item \code{isQueen()}: Is individual a queen

\item \code{isFather()}: Is individual a father

\item \code{isWorker()}: Is individual a worker

\item \code{isDrone()}: Is individual a drone

\item \code{isVirginQueen()}: Is individual a virgin queen

}}
\examples{
founderGenomes <- quickHaplo(nInd = 8, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
colony <- buildUp(x = colony, nWorkers = 120, nDrones = 20)
colony <- addVirginQueens(x = colony, nInd = 4)

isCaste(getQueen(colony), caste = "queen")
isCaste(getFathers(colony, nInd = 2), caste = "fathers")
isCaste(getWorkers(colony, nInd = 2), caste = "workers") # random sample!
isCaste(getDrones(colony, nInd = 2), caste = "drones")
isCaste(getVirginQueens(colony, nInd = 2), caste = "virginQueens")

bees <- c(
  getQueen(colony),
  getFathers(colony, nInd = 2),
  getWorkers(colony, nInd = 2),
  getDrones(colony, nInd = 2),
  getVirginQueens(colony, nInd = 2)
)
isCaste(bees, caste = "queen")
isCaste(bees, caste = "fathers")
isCaste(bees, caste = "workers")
isCaste(bees, caste = "drones")
isCaste(bees, caste = "virginQueens")

isQueen(getQueen(colony))
isQueen(getFathers(colony, nInd = 2))

isFather(getQueen(colony))
isFather(getFathers(colony, nInd = 2))

isWorker(getQueen(colony))
isWorker(getFathers(colony, nInd = 2))
isWorker(getWorkers(colony, nInd = 2))

isDrone(getQueen(colony))
isDrone(getFathers(colony, nInd = 2))
isDrone(getDrones(colony, nInd = 2))

isVirginQueen(getQueen(colony))
isVirginQueen(getFathers(colony, nInd = 2))
isVirginQueen(getVirginQueens(colony, nInd = 2))

}
\seealso{
\code{\link{isQueen}}, \code{\link{isFather}},
  \code{\link{isVirginQueen}}, \code{\link{isWorker}}, and
  \code{\link{isDrone}}
}
