% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L2_Colony.R
\name{addCastePop}
\alias{addCastePop}
\alias{addWorkers}
\alias{addDrones}
\alias{addVirginQueens}
\title{Add caste individuals to the colony}
\usage{
addCastePop(
  x,
  caste = NULL,
  nInd = NULL,
  new = FALSE,
  exact = FALSE,
  year = NULL,
  simParamBee = NULL,
  ...
)

addWorkers(x, nInd = NULL, new = FALSE, exact = FALSE, simParamBee = NULL, ...)

addDrones(x, nInd = NULL, new = FALSE, simParamBee = NULL, ...)

addVirginQueens(
  x,
  nInd = NULL,
  new = FALSE,
  year = NULL,
  simParamBee = NULL,
  ...
)
}
\arguments{
\item{x}{\code{\link{Colony-class}} or \code{\link{MultiColony-class}}}

\item{caste}{character, "workers", "drones", or "virginQueens"}

\item{nInd}{numeric or function, number of workers to be added, but see
\code{new}; if \code{NULL} then \code{\link{SimParamBee}$nWorkers} is used.
If input is \code{\link{MultiColony-class}},
the input could also be a vector of the same length as the number of colonies. If
a single value is provided, the same value will be used for all the colonies.}

\item{new}{logical, should the number of individuals be added to the caste population
anew or should we only top-up the existing number of individuals to \code{nInd}}

\item{exact}{logical, only relevant when adding workers - if the csd locus is turned
on and exact is \code{TRUE}, we add the exact specified number of viable workers
(heterozygous at the csd locus)}

\item{year}{numeric, only relevant when adding virgin queens - year of birth for virgin queens}

\item{simParamBee}{\code{\link{SimParamBee}}, global simulation parameters}

\item{...}{additional arguments passed to \code{nInd} when this argument is a function}
}
\value{
\code{\link{Colony-class}} or \code{\link{MultiColony-class}} with
  workers added
}
\description{
Level 2 function that adds (raises) the specified number of
  a specific caste individuals to a Colony or MultiColony object by producing
  offspring from a mated queen. If there are already some individuals present
  in the caste, new and present individuals are combined.
}
\details{
This function increases queen's \code{nWorkers} and \code{nHomBrood}
  counters.
}
\section{Functions}{
\itemize{
\item \code{addWorkers()}: Add workers to a colony

\item \code{addDrones()}: Add drones to a colony

\item \code{addVirginQueens()}: Add virgin queens to a colony

}}
\examples{
founderGenomes <- quickHaplo(nInd = 5, nChr = 1, segSites = 50)
SP <- SimParamBee$new(founderGenomes)
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 100)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 5, nDrones = nFathersPoisson)

# Create and cross Colony and MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
apiary <- createMultiColony(basePop[4:5], n = 2)
apiary <- cross(apiary, drones = droneGroups[3:4])

#Here we show an example for workers, but same holds for drones and virgin queens!
# Add workers
addCastePop(colony, caste = "workers", nInd = 20)
# Or use a alias function
addWorkers(colony, nInd = 20)
# Same aliases exist for drones and virgin queens!

# If nInd is NULL, the functions uses the default in SP$nWorkers
# We can change this default
SP$nWorkers <- 15
nWorkers(addWorkers(colony))
# nVirginQueens/nWorkers/nDrones will NOT vary between function calls when a constant is used

# Specify a function that will give a number
nWorkers(addWorkers(colony, nInd = nWorkersPoisson))
nWorkers(addWorkers(colony, nInd = nWorkersPoisson))
# nVirginQueens/nWorkers/nDrones will vary between function calls when a function is used

# Store a function or a value in the SP object
SP$nWorkers <- nWorkersPoisson
(addWorkers(colony))
# nVirginQueens/nWorkers/nDrones will vary between function calls when a function is used

# Queen's counters
getMisc(getQueen(addWorkers(colony)))

# Add individuals to a MultiColony object
apiary <- addWorkers(apiary)
# Add different number of workers to colonies
nWorkers(addWorkers(apiary, nInd = c(50, 100)))

}
