% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extended.gcd.r
\name{extended.gcd}
\alias{extended.gcd}
\title{Extended Greatest Common Denominator (GCD) algorithm.}
\usage{
extended.gcd(a, b)
}
\arguments{
\item{a}{A vector of integers}

\item{b}{A vector of integers.  \code{length(a)} must equal \code{length(b)}.}
}
\value{
a data frame containing 5 columns; \code{a}, \code{t}, 
 \code{b}, \code{s}, and \code{gcd}.  
 Number of rows in output equals length of input \code{a}.
}
\description{
Implements the extended Euclidean algorithm which 
computes the greatest common divisor and solves Bezout's identity.
}
\details{
This routine computes the element-wise gcd and 
 coefficients s and t such that a*t + b*s = d. In other words, if 
 \code{x = extended.gcd(a,b)}, then \code{x$a*x$t + x$b*x$s == x$gcd}
 
 The Wikipedia page, from which this algorithm was stolen, has the 
 following statement, 'The quotients of a and b by their greatest common divisor, 
 which are output, may have an incorrect sign.  This is easy to correct at the end
 of the computation, but has not been done here for simplifying the code.' 
 I have absolutely no 
 idea what that means, but include it as a warning.  For purposes of 
 \code{SDraw}, elements of a and b are always positive, and I have never 
 observed "incorrect signs".  But, there may be some pathological cases 
 where "incorrect signs" occur, and the user should "correct" for this.  
 This routine does check that the output gcd is 
 positive, and corrects this and the signs of s and t if so.
}
\examples{
 x <- extended.gcd( c(16,27,27,46), c(9,16,9,240) )
 
 #  Check
 cbind(x$a*x$t + x$b*x$s, x$gcd)
 
}
\references{
Code is based on the following Wikipedia pseudo-code: 
 \url{https://en.wikipedia.org/wiki/Extended_Euclidean_algorithm}
}
\author{
Trent McDonald
}
