% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/null.model.R
\name{null.model}
\alias{null.model}
\title{Compute null model}
\usage{
null.model(predictors, xy = NULL, type = c(1, 2), algorithm = c("brt", "maxent"), nb,
         unique.data = T, same = T, background.nb = nb, nb.rep = 10, tc = 2,
         lr = 0.001, bf = 0.75, n.trees = 50, step.size = n.trees)
}
\arguments{
\item{predictors}{Rasterstack object that contains the predictors that will be used for species distribution models}

\item{xy}{Dataframe that contains the longitude and latitude of the visited pixels. Information required to perform type 1 null model. Default= NULL}

\item{type}{Null model type to perform. type=1 to perform a null model based on visited areas, type=2 to predict random model}

\item{algorithm}{Algorithm to compute the null model. 'brt' or 'maxent'}

\item{nb}{Number of points to randomly sample (among the matrix of visited pixels for 'type=1' model or in the entire geographic space for 'type=2')}

\item{unique.data}{If TRUE (default), pixel duplicates contained in 'xy' are removed}

\item{same}{If TRUE (default), the number of background data sampled in the area will be 'nb'}

\item{background.nb}{Number of background data to sample. If this argument is filled, 'same' is set FALSE.}

\item{nb.rep}{Null models number of replicates. See \link{compute.brt}}

\item{tc}{BRT parameter. Integer. Tree complexity. Sets the complexity of individual trees. See \link{compute.brt}}

\item{lr}{BRT parameter.Learning rate. Sets the weight applied to individual trees. See \link{compute.brt}}

\item{bf}{BRT parameter.Bag fraction. Sets the proportion of observations used in selecting variables. See \link{compute.brt}}

\item{n.trees}{BRT parameter.Number of initial trees to fit. Set at 50 by default. See \link{compute.brt}}

\item{step.size}{BRT parameter.Number of trees to add at each cycle. See \link{compute.brt}}
}
\value{
List of 6
\itemize{
\item \emph{$inputs}      Remembers the arguments used to implement null.model function
\item \emph{$eval}        Evaluation parameters of each model that compose the null model. See \link{SDMeval} for further information
\item \emph{$eval.null}   Evaluation of the mean null model. See \link{SDMeval} for further information
\item \emph{$pred.stack}  RasterStack of all the models produced to build the null model
\item \emph{$pred.mean}   Raster layer. Null model prediction. Mean of the $pred.stack RasterStack
\item \emph{$correlation} Spearman rank test value between the different maps produced }
}
\description{
Compute null model. Null models are useful tools to highlight an a priori evaluation of the influence of presence records spatial structuration in model predictions (i.e. influence of aggregated sampling).
\cr Null model type #1 performs a model by randomly sampling locations from the ensemble of visited stations, therefore simulating the influence of sampling effort on model predictions.

Null model type #2 samples data in the entire study area, and reflects what should be predicted if occurrences were randomly distributed in the area.

Models should be replicated \emph{nb.rep} times in order to estimate statistical scores.
}
\details{
Data are sampled without replacement.
Each time the model is runned, new data (presence and background data) are sampled
}
\note{
Increasing the number of replications will enhance model null relevance (we advice nb.rep=100 for minimum). Please note that processing may take few minutes to hours.

If you want to build a MaxEnt model, \link{compute.maxent} uses the functionalities of the \link[dismo]{maxent} function. This function uses MaxEnt species distribution software, which is a java program that could be downloaded at \url{https://github.com/charleneguillaumot/SDMPlay}. In order to run compute.maxent, put the 'maxent.jar' file downloaded at this adress in the 'java' folder of the dismo package (path obtained with the system.file('java', package='dismo') command). MaxEnt 3.3.3b version or higher is required.
}
\examples{
\dontrun{
# Load environmental predictors
data(predictors2005_2012)
envi <- predictors2005_2012
envi

# Realise a null model type #2 with BRT
#--------------------------------------
modelN2 <- SDMPlay:::null.model(xy=NULL,predictors=envi,type=2,algorithm='brt',
                     nb=300,unique.data=TRUE, same=TRUE, nb.rep=2,lr=0.0005)

# Look at the inputs used to implement the model
modelN2$input

# Get the evaluation of the models produced
modelN2$eval

# Get the evaluation of the mean of all these produced models (i.e. evaluation
# of the null model)
modelN2$eval.null

# Get the values of Spearman correlations between the all the prediction maps produced
modelN2$correlation

# Plot the mean null model map with nice colors
library(grDevices)
palet.col <- colorRampPalette(c('deepskyblue','green','yellow', 'red'))(80)
data('worldmap')
raster::plot(modelN2$pred.mean, col=palet.col)
points(worldmap, type="l")
}
}
\seealso{
\link[dismo]{nicheOverlap}: compare prediction maps
\link[rJava]{.jpackage}: initialize dismo for Java
}
