% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaultDebugRBF.R
\name{debugVisualizeRBF}
\alias{debugVisualizeRBF}
\title{Optional visualization of surrogate models for 2-dimensional problems, d=2.}
\usage{
debugVisualizeRBF(cobra, fitnessSurrogate, A, Fres)
}
\arguments{
\item{fitnessSurrogate}{The surrogate model for the objective function}

\item{A}{The whole population of solutions which is a matrix of n times d, where n is the number of solutions and d is the dimension of problem, here d=2}

\item{Fres}{The objective value on the evaluated solutions \code{A}}

\item{\code{cobra}}{parameter list, we need here 
\describe{
  \item{\code{DEBUG_RBF$overlayTrueZ}}{=T: overlay the true objective function}
  \item{\code{DEBUG_RBF$DO_SNAPSHOT}}{=T: do rgl.snapshot every \code{DEBUG_RBF$every} iteration and store it in \code{sprintf("images.d/\%s-\%03d.png",cobra$fname,npts)} }
  \item{\code{DEBUG_RBF$every}}{  see above}}}
}
\value{
\code{cobra}, an object of class COBRA, with modified items:
   \item{\code{TrueZ}}{True objective values of the evaluated points used for viusalization}
   \item{\code{TrueFeas}}{A vector of values 0: for infeasible evaluated points or 1: for feasible points.}
   \item{\code{globalDevice}}{}
This function is called only if cobra$DEBUG_RBF$active==T.
An assertion fires if cobra$dimension!=2 or if cobra$rescale==F.
}
\description{
Optional visualization of surrogate models for 2-dimensional problems, d=2.
}
\keyword{internal}
