% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cobraPhaseII.R
\name{cobraPhaseII}
\alias{cobraPhaseII}
\title{Improve the feasible solution by searching new infill points}
\usage{
cobraPhaseII(cobra)
}
\arguments{
\item{cobra}{an object of class COBRA, this is a (long) list containing all settings
     from \code{\link{cobraInit}}}
}
\value{
\code{cobra}, an object of class COBRA from \code{\link{cobraInit}},
   enhanced here by the following elements (among others):
     \item{\code{fn}}{ function returning an (m+1)-vector \code{c(objective,g1,...,gm)}. This
           function may be a rescaled and plog-transformed version of the original \code{fn}
           passed into \code{\link{cobraInit}}. The original \code{fn} is in
           \code{cobra$originalFn}. }
     \item{\code{df}}{  data frame with summary of the optimization run (see below)}
     \item{\code{df2}}{  data frame with additional summary information (see below)}
     \item{\code{A}}{ (feval x dim)-matrix containing all evaluated points
           in input space. If rescale==TRUE, all points are in \strong{rescaled} input space. }
     \item{\code{Fres}}{ a vector of the objective values of all evaluated points }
     \item{\code{Gres}}{ a matrix of the constraint values of all evaluated points }
     \item{\code{fbest}}{ the best feasible objective value found }
     \item{\code{xbest}}{ the point in input space yielding the best feasible objective value }
     \item{\code{ibest}}{ the corresponding iteration number (row of cobra$df, of cobra$A)}
     \item{\code{PLOG}}{ If TRUE, then the objective surrogate model is trained on the
           \code{\link{plog}}-transformed objective function. }

  Note that \code{cobra$Fres}, \code{cobra$fbest}, \code{cobra$fbestArray} and similar contain
  always the objective values of the orignial function \code{cobra$fn[1]}. (The surrogate models
  may be trained on a \code{\link{plog}}-transformed version of this function.)

  The data frame \code{cobra$df} contains one row per iteration with columns
  \describe{
     \item{iter}{  }
     \item{y}{   true objective value \code{Fres} }
     \item{predY}{  surrogate objective value. Note: The surrogate may be trained on
           plog-transformed training data, but \code{predY} is transformed back to the original
           objective range. NA for the initial design points.}
     \item{predSolu}{  surrogate objective value at best-known solution \code{cobra$solu}, if given.
           If \code{cobra$solu} is NULL, take the current point instead. Note: The surrogate may be trained on
           plog-transformed training data, but \code{predSolu} is transformed back to the original
           objective range. NA for the initial design points.}
     \item{feasible}{  }
     \item{feasPred}{  }
     \item{nViolations}{  }
     \item{maxViolation}{  }
     \item{FEval}{  number of function evaluations in sequential optimizer. NA if it was a repair step }
     \item{Best}{  ever-best feasible objective value \code{fbest}. As long as there is
           no feasible point, take among those with minimum number of violated constraints the
           one with minimum Fres. }
     \item{optimizer}{ e.g. "COBYLA"  }
     \item{optimizationTime}{  in sec}
     \item{conv}{  }
     \item{seed}{  }
  }

  The data frame \code{cobra$df2} contains one row per phase-II-iteration with columns
  \describe{
     \item{iter}{  }
     \item{predY}{  surrogate objective value. Note: The surrogate may be trained on
           plog-transformed training data, but \code{predY} is transformed back to the original
           objective range. NA for the initial design points.}
     \item{predVal}{   surrogate objective value + penalty }
     \item{predSolu}{   surrogate objective value at true solution (see \code{cobra$df$predSolu}) }
     \item{predSoluPenal}{   surrogate objective value + penalty at true solution (only diagnostics)}
     \item{sigmaD}{  }
     \item{penaF}{  }
     \item{XI}{  the DRC element used in the current iteration }
     \item{EPS}{  }
  }
}
\description{
Improve the feasible solution using the COBRA optimizer phase II
 by searching new infill points with the help of RBF surrogate models.
 May be even called if no feasible solution is found yet, then phase II will try to find
 feasible solutions.
}
\author{
Wolfgang Konen, Samineh Bagheri, Patrick Koch, Cologne Univeristy of Applied Sciences
}
\seealso{
\code{\link{cobraPhaseI}}, \code{\link{cobraInit}}
}

