% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxParams.R
\name{rxParams}
\alias{rxParams}
\alias{rxParams.RxODE}
\alias{rxParams.rxSolve}
\alias{rxParams.rxEt}
\alias{rxParam}
\title{Parameters specified by the model}
\usage{
rxParams(obj, ...)

\method{rxParams}{RxODE}(
  obj,
  constants = TRUE,
  ...,
  params = NULL,
  inits = NULL,
  iCov = NULL,
  keep = NULL,
  thetaMat = NULL,
  omega = NULL,
  dfSub = NULL,
  sigma = NULL,
  dfObs = NULL,
  nSub = NULL,
  nStud = NULL
)

\method{rxParams}{rxSolve}(
  obj,
  constants = TRUE,
  ...,
  params = NULL,
  inits = NULL,
  iCov = NULL,
  keep = NULL,
  thetaMat = NULL,
  omega = NULL,
  dfSub = NULL,
  sigma = NULL,
  dfObs = NULL,
  nSub = NULL,
  nStud = NULL
)

\method{rxParams}{rxEt}(
  obj,
  ...,
  params = NULL,
  inits = NULL,
  iCov = NULL,
  keep = NULL,
  thetaMat = NULL,
  omega = NULL,
  dfSub = NULL,
  sigma = NULL,
  dfObs = NULL,
  nSub = NULL,
  nStud = NULL
)

rxParam(obj, ...)
}
\arguments{
\item{obj}{RxODE family of objects}

\item{...}{Other arguments including scaling factors for each
compartment.  This includes S# = numeric will scale a compartment
# by a dividing the compartment amount by the scale factor,
like NONMEM.}

\item{constants}{is a boolean indicting if constants should be
included in the list of parameters. Currently RxODE parses
constants into variables in case you wish to change them
without recompiling the RxODE model.}

\item{params}{a numeric named vector with values for every
parameter in the ODE system; the names must correspond to the
parameter identifiers used in the ODE specification;}

\item{inits}{a vector of initial values of the state variables
(e.g., amounts in each compartment), and the order in this
vector must be the same as the state variables (e.g., PK/PD
compartments);}

\item{iCov}{A data frame of individual non-time varying covariates
to combine with the \code{events} dataset by merge.}

\item{keep}{Columns to keep from either the input dataset or the
\code{iCov} dataset.  With the \code{iCov} dataset, the column
is kept once per line.  For the input dataset, if any records
are added to the data LOCF (Last Observation Carried forward)
imputation is performed.}

\item{thetaMat}{Named theta matrix.}

\item{omega}{Estimate of Covariance matrix. When omega is a list,
assume it is a block matrix and convert it to a full matrix
for simulations.}

\item{dfSub}{Degrees of freedom to sample the between subject variability matrix from the
inverse Wishart distribution (scaled) or scaled inverse chi squared distribution.}

\item{sigma}{Named sigma covariance or Cholesky decomposition of a
covariance matrix.  The names of the columns indicate
parameters that are simulated.  These are simulated for every
observation in the solved system.}

\item{dfObs}{Degrees of freedom to sample the unexplained variability matrix from the
inverse Wishart distribution (scaled) or scaled inverse chi squared distribution.}

\item{nSub}{Number between subject variabilities (\code{ETAs}) simulated for every
realization of the parameters.}

\item{nStud}{Number virtual studies to characterize uncertainty in estimated
parameters.}
}
\value{
When extracting the parameters from an RxODE model, a
character vector listing the parameters in the model.
}
\description{
This returns the model's parameters that are required to solve the
ODE system, and can be used to pipe parameters into an RxODE solve
}
\author{
Matthew L.Fidler
}
