% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend_functions.R
\name{tsEvaTransformSeriesToStationaryPeakTrend}
\alias{tsEvaTransformSeriesToStationaryPeakTrend}
\title{tsEvaTransformSeriesToStationaryPeakTrend}
\usage{
tsEvaTransformSeriesToStationaryPeakTrend(
  timeStamps,
  series,
  timeWindow,
  TrendTh
)
}
\arguments{
\item{timeStamps}{A vector of time stamps corresponding to the observations in the series.}

\item{series}{A vector of the time series data.}

\item{timeWindow}{The size of the time window used for detrending.}

\item{TrendTh}{The threshold for fitting the trend on the means above a
given quantile. Default is 0.5.}
}
\value{
A list containing the following components:
\describe{
\item{\code{runningStatsMulteplicity}}{The multiplicity of running statistics.}
\item{\code{stationarySeries}}{The stationary series after removing the trend.}
\item{\code{trendSeries}}{The trend component of the series.}
\item{\code{trendSeriesNonSeasonal}}{NULL (not used).}
\item{\code{trendError}}{The error on the trend component.}
\item{\code{stdDevSeries}}{The standard deviation series.}
\item{\code{stdDevSeriesNonSeasonal}}{NULL (not used).}
\item{\code{stdDevError}}{The error on the standard deviation series.}
\item{\code{timeStamps}}{The time stamps.}
\item{\code{nonStatSeries}}{The original non-stationary series.}
\item{\code{statSer3Mom}}{The running mean of the third moment of the stationary series.}
\item{\code{statSer4Mom}}{The running mean of the fourth moment of the stationary series.}
}
}
\description{
\code{tsEvaTransformSeriesToStationaryPeakTrend}
transforms a time series to a stationary one by focusing on extremes.
The trend and slowly varying amplitude are computed on values above a
threshold defined by the user or automatically
with the function \code{tsEvaFindTrendThreshold}.
}
\examples{
timeAndSeries <- ArdecheStMartin
timeStamps <- ArdecheStMartin[,1]
series <- ArdecheStMartin[,2]
#select only the 5 latest years
yrs <- as.integer(format(timeStamps, "\%Y"))
tokeep <- which(yrs>=2015)
timeStamps <- timeStamps[tokeep]
series <- series[tokeep]
timeWindow <- 365 # 1 year
TrendTh <- NA
result <- tsEvaTransformSeriesToStationaryPeakTrend(timeStamps,
series, timeWindow, TrendTh)
plot(result$trendSeries)

}
\seealso{
\code{\link[=tsEvaFindTrendThreshold]{tsEvaFindTrendThreshold()}}
}
