% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend_functions.R
\name{tsEvaTransformSeriesToStationaryTrendAndChangepts_ciPercentile}
\alias{tsEvaTransformSeriesToStationaryTrendAndChangepts_ciPercentile}
\title{Transform Time Series to Stationary Trend and Change Points with Confidence Intervals}
\usage{
tsEvaTransformSeriesToStationaryTrendAndChangepts_ciPercentile(
  timeStamps,
  series,
  timeWindow,
  percentile
)
}
\arguments{
\item{timeStamps}{A vector of time stamps corresponding to the observations in the series.}

\item{series}{The time series data.}

\item{timeWindow}{The size of the sliding window used for detrending the series.}

\item{percentile}{The percentile value used for computing the running percentile of the stationary series.}
}
\value{
A list containing the following elements:
\describe{
\item{\code{runningStatsMulteplicity}}{The running statistics multiplicity}
\item{\code{stationarySeries}}{The transformed stationary series}
\item{\code{trendSeries}}{The trend series}
\item{\code{trendonlySeries}}{The trend series without the stationary component}
\item{\code{ChpointsSeries2}}{The trend series with change points}
\item{\code{changePoints}}{The detected change points}
\item{\code{trendSeriesNonSeasonal}}{The trend series without the seasonal component}
\item{\code{trendError}}{The error on the trend}
\item{\code{stdDevSeries}}{The standard deviation series}
\item{\code{stdDevSeriesNonStep}}{The standard deviation series without the step change component}
\item{\code{stdDevError}}{The error on the standard deviation}
\item{\code{timeStamps}}{The time stamps}
\item{\code{nonStatSeries}}{The original non-stationary series}
\item{\code{statSer3Mom}}{The running mean of the third moment of the stationary series}
\item{\code{statSer4Mom}}{The running mean of the fourth moment of the stationary series}
}
}
\description{
This function takes a time series and transforms it into a stationary trend series with change points and confidence intervals.
}
\examples{
timeAndSeries <- ArdecheStMartin

#go from six-hourly values to daily max
timeAndSeries <- max_daily_value(timeAndSeries)
timeStamps <- timeAndSeries[,1]
series <- timeAndSeries[,2]

#select only the 5 latest years
yrs <- as.integer(format(timeStamps, "\%Y"))
tokeep <- which(yrs>=2015)
timeStamps <- timeStamps[tokeep]
series <- series[tokeep]
timeWindow <- 365 # 1 year
percentile <- 90
result <- tsEvaTransformSeriesToStationaryTrendAndChangepts_ciPercentile(timeStamps,
series, timeWindow, percentile)
plot(result$trendSeries)
}
