% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyhedra-lib.R
\docType{class}
\name{PolyhedronState}
\alias{PolyhedronState}
\title{PolyhedronState}
\description{
This abstract class provide the basis from which every polyhedron state class derivate.
}
\author{
ken4rab
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{source}}{polyhedron definition source}

\item{\code{file.id}}{polyhedron file id}

\item{\code{errors}}{Errors string}

\item{\code{logger}}{class logger}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PolyhedronState-new}{\code{PolyhedronState$new()}}
\item \href{#method-PolyhedronState-addError}{\code{PolyhedronState$addError()}}
\item \href{#method-PolyhedronState-scrape}{\code{PolyhedronState$scrape()}}
\item \href{#method-PolyhedronState-getName}{\code{PolyhedronState$getName()}}
\item \href{#method-PolyhedronState-getSolid}{\code{PolyhedronState$getSolid()}}
\item \href{#method-PolyhedronState-checkEdgesConsistency}{\code{PolyhedronState$checkEdgesConsistency()}}
\item \href{#method-PolyhedronState-applyTransformationMatrix}{\code{PolyhedronState$applyTransformationMatrix()}}
\item \href{#method-PolyhedronState-buildRGL}{\code{PolyhedronState$buildRGL()}}
\item \href{#method-PolyhedronState-exportToXML}{\code{PolyhedronState$exportToXML()}}
\item \href{#method-PolyhedronState-clone}{\code{PolyhedronState$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronState-new"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronState-new}{}}}
\subsection{Method \code{new()}}{
Create a polyhedronState object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronState$new(source, file.id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{the source file}

\item{\code{file.id}}{the file id}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new  PolyhedronState object.
'@description
Adds an error to the error string and log it as info
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronState-addError"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronState-addError}{}}}
\subsection{Method \code{addError()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronState$addError(current.error)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{current.error}}{the error to add}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronState-scrape"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronState-scrape}{}}}
\subsection{Method \code{scrape()}}{
Scrapes the polyhedra folder files
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronState$scrape()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronState-getName"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronState-getName}{}}}
\subsection{Method \code{getName()}}{
Get Polyhedron name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronState$getName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string with polyhedron name
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronState-getSolid"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronState-getSolid}{}}}
\subsection{Method \code{getSolid()}}{
Returns the object corresponding to the solid
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronState$getSolid()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronState-checkEdgesConsistency"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronState-checkEdgesConsistency}{}}}
\subsection{Method \code{checkEdgesConsistency()}}{
Checks edge consistency
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronState$checkEdgesConsistency()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronState-applyTransformationMatrix"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronState-applyTransformationMatrix}{}}}
\subsection{Method \code{applyTransformationMatrix()}}{
Apply transformation matrix to polyhedron
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronState$applyTransformationMatrix(transformation.matrix)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{transformation.matrix}}{the transformation matrix to apply to the polyhedron}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronState-buildRGL"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronState-buildRGL}{}}}
\subsection{Method \code{buildRGL()}}{
Creates a 'rgl' representation of the object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronState$buildRGL(transformation.matrix)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{transformation.matrix}}{the transformation matrix to apply to the polyhedron}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronState-exportToXML"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronState-exportToXML}{}}}
\subsection{Method \code{exportToXML()}}{
Gets an XML representation out of the polyhedron object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronState$exportToXML()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronState-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronState-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronState$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
