/*
 * Decompiled with CFR 0.152.
 */
package org.math.r.activemq.logger;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTextMessage;

public class Consumer {
    private String url = "failover://tcp://localhost:61616";
    private Session session;
    private MessageConsumer consumer;
    private Connection connection;

    public Consumer(String url, String field, String name) {
        if (url != null) {
            this.url = url;
        }
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.url);
        try {
            this.connection = connectionFactory.createConnection();
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
            Object destination = "T".equals(field) ? this.session.createTopic(name) : this.session.createQueue(name);
            this.consumer = this.session.createConsumer((Destination)destination);
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public byte[] consume(String propertyName, String propertyValue, long timeOutMillis) {
        byte[] obj = null;
        try {
            String expectedPropertyValue;
            ActiveMQMessage message = (ActiveMQMessage)this.consumer.receive(timeOutMillis);
            if (message instanceof ActiveMQBytesMessage) {
                obj = message.getContent().getData();
            } else if (message instanceof ActiveMQTextMessage) {
                obj = ((ActiveMQTextMessage)message).getText().toString().getBytes();
            }
            if (propertyName != null && propertyValue != null && !propertyValue.equals(expectedPropertyValue = message.getStringProperty(propertyName))) {
                obj = null;
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public boolean destroy() {
        Boolean success = false;
        try {
            this.connection.close();
            success = true;
        }
        catch (JMSException e) {
            e.printStackTrace();
            success = false;
        }
        return success;
    }
}

