/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.common.ImageMetadata;
import org.apache.sanselan.common.RationalNumber;
import org.apache.sanselan.formats.tiff.JpegImageData;
import org.apache.sanselan.formats.tiff.TiffContents;
import org.apache.sanselan.formats.tiff.TiffDirectory;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.TiffImageData;
import org.apache.sanselan.formats.tiff.constants.TagInfo;
import org.apache.sanselan.formats.tiff.constants.TiffConstants;
import org.apache.sanselan.formats.tiff.constants.TiffDirectoryConstants;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldType;
import org.apache.sanselan.formats.tiff.write.TiffOutputDirectory;
import org.apache.sanselan.formats.tiff.write.TiffOutputField;
import org.apache.sanselan.formats.tiff.write.TiffOutputSet;

public class TiffImageMetadata
extends ImageMetadata
implements TiffDirectoryConstants {
    public final TiffContents contents;

    public TiffImageMetadata(TiffContents contents) {
        this.contents = contents;
    }

    public ArrayList getDirectories() {
        return super.getItems();
    }

    public ArrayList getItems() {
        ArrayList result = new ArrayList();
        ArrayList items = super.getItems();
        for (int i = 0; i < items.size(); ++i) {
            Directory dir = (Directory)items.get(i);
            result.addAll(dir.getItems());
        }
        return result;
    }

    public TiffOutputSet getOutputSet() throws ImageWriteException {
        int byteOrder = this.contents.header.byteOrder;
        TiffOutputSet result = new TiffOutputSet(byteOrder);
        ArrayList srcDirs = this.getDirectories();
        for (int i = 0; i < srcDirs.size(); ++i) {
            Directory srcDir = (Directory)srcDirs.get(i);
            if (null != result.findDirectory(srcDir.type)) continue;
            TiffOutputDirectory outputDirectory = srcDir.getOutputDirectory(byteOrder);
            result.addDirectory(outputDirectory);
        }
        return result;
    }

    public TiffField findField(TagInfo tagInfo) throws ImageReadException {
        ArrayList directories = this.getDirectories();
        for (int i = 0; i < directories.size(); ++i) {
            Directory directory = (Directory)directories.get(i);
            TiffField field = directory.findField(tagInfo);
            if (null == field) continue;
            return field;
        }
        return null;
    }

    public TiffDirectory findDirectory(int directoryType) {
        ArrayList directories = this.getDirectories();
        for (int i = 0; i < directories.size(); ++i) {
            Directory directory = (Directory)directories.get(i);
            if (directory.type != directoryType) continue;
            return directory.directory;
        }
        return null;
    }

    public List getAllFields() throws ImageReadException {
        ArrayList result = new ArrayList();
        ArrayList directories = this.getDirectories();
        for (int i = 0; i < directories.size(); ++i) {
            Directory directory = (Directory)directories.get(i);
            result.addAll(directory.getAllFields());
        }
        return result;
    }

    public GPSInfo getGPS() throws ImageReadException {
        TiffDirectory gpsDirectory = this.findDirectory(-3);
        if (null == gpsDirectory) {
            return null;
        }
        TiffField latitudeRefField = gpsDirectory.findField(TiffConstants.GPS_TAG_GPS_LATITUDE_REF);
        TiffField latitudeField = gpsDirectory.findField(TiffConstants.GPS_TAG_GPS_LATITUDE);
        TiffField longitudeRefField = gpsDirectory.findField(TiffConstants.GPS_TAG_GPS_LONGITUDE_REF);
        TiffField longitudeField = gpsDirectory.findField(TiffConstants.GPS_TAG_GPS_LONGITUDE);
        if (latitudeRefField == null || latitudeField == null || longitudeRefField == null || longitudeField == null) {
            return null;
        }
        String latitudeRef = latitudeRefField.getStringValue();
        RationalNumber[] latitude = (RationalNumber[])latitudeField.getValue();
        String longitudeRef = longitudeRefField.getStringValue();
        RationalNumber[] longitude = (RationalNumber[])longitudeField.getValue();
        if (latitude.length != 3 || longitude.length != 3) {
            throw new ImageReadException("Expected three values for latitude and longitude.");
        }
        RationalNumber latitudeDegrees = latitude[0];
        RationalNumber latitudeMinutes = latitude[1];
        RationalNumber latitudeSeconds = latitude[2];
        RationalNumber longitudeDegrees = longitude[0];
        RationalNumber longitudeMinutes = longitude[1];
        RationalNumber longitudeSeconds = longitude[2];
        return new GPSInfo(latitudeRef, longitudeRef, latitudeDegrees, latitudeMinutes, latitudeSeconds, longitudeDegrees, longitudeMinutes, longitudeSeconds);
    }

    public static class GPSInfo {
        public final String latitudeRef;
        public final String longitudeRef;
        public final RationalNumber latitudeDegrees;
        public final RationalNumber latitudeMinutes;
        public final RationalNumber latitudeSeconds;
        public final RationalNumber longitudeDegrees;
        public final RationalNumber longitudeMinutes;
        public final RationalNumber longitudeSeconds;

        public GPSInfo(String latitudeRef, String longitudeRef, RationalNumber latitudeDegrees, RationalNumber latitudeMinutes, RationalNumber latitudeSeconds, RationalNumber longitudeDegrees, RationalNumber longitudeMinutes, RationalNumber longitudeSeconds) {
            this.latitudeRef = latitudeRef;
            this.longitudeRef = longitudeRef;
            this.latitudeDegrees = latitudeDegrees;
            this.latitudeMinutes = latitudeMinutes;
            this.latitudeSeconds = latitudeSeconds;
            this.longitudeDegrees = longitudeDegrees;
            this.longitudeMinutes = longitudeMinutes;
            this.longitudeSeconds = longitudeSeconds;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append("[GPS. ");
            result.append("Latitude: " + this.latitudeDegrees.toDisplayString() + " degrees, " + this.latitudeMinutes.toDisplayString() + " minutes, " + this.latitudeSeconds.toDisplayString() + " seconds " + this.latitudeRef);
            result.append(", Longitude: " + this.longitudeDegrees.toDisplayString() + " degrees, " + this.longitudeMinutes.toDisplayString() + " minutes, " + this.longitudeSeconds.toDisplayString() + " seconds " + this.longitudeRef);
            result.append("]");
            return result.toString();
        }

        public double getLongitudeAsDegreesEast() throws ImageReadException {
            double result = this.longitudeDegrees.doubleValue() + this.longitudeMinutes.doubleValue() / 60.0 + this.longitudeSeconds.doubleValue() / 3600.0;
            if (this.longitudeRef.trim().equalsIgnoreCase("e")) {
                return result;
            }
            if (this.longitudeRef.trim().equalsIgnoreCase("w")) {
                return -result;
            }
            throw new ImageReadException("Unknown longitude ref: \"" + this.longitudeRef + "\"");
        }

        public double getLatitudeAsDegreesNorth() throws ImageReadException {
            double result = this.latitudeDegrees.doubleValue() + this.latitudeMinutes.doubleValue() / 60.0 + this.latitudeSeconds.doubleValue() / 3600.0;
            if (this.latitudeRef.trim().equalsIgnoreCase("n")) {
                return result;
            }
            if (this.latitudeRef.trim().equalsIgnoreCase("s")) {
                return -result;
            }
            throw new ImageReadException("Unknown latitude ref: \"" + this.latitudeRef + "\"");
        }
    }

    public static class Item
    extends ImageMetadata.Item {
        private final TiffField entry;

        public Item(TiffField entry) {
            super(entry.getTagName(), entry.getValueDescription());
            this.entry = entry;
        }

        public TiffField getTiffField() {
            return this.entry;
        }
    }

    public static class Directory
    extends ImageMetadata
    implements IImageMetadata.IImageMetadataItem {
        public final int type;
        private final TiffDirectory directory;

        public Directory(TiffDirectory directory) {
            this.type = directory.type;
            this.directory = directory;
        }

        public void add(TiffField entry) {
            this.add(new Item(entry));
        }

        public BufferedImage getThumbnail() throws ImageReadException, IOException {
            return this.directory.getTiffImage();
        }

        public TiffImageData getTiffImageData() {
            return this.directory.getTiffImageData();
        }

        public TiffField findField(TagInfo tagInfo) throws ImageReadException {
            return this.directory.findField(tagInfo);
        }

        public List getAllFields() throws ImageReadException {
            return this.directory.getDirectoryEntrys();
        }

        public JpegImageData getJpegImageData() {
            return this.directory.getJpegImageData();
        }

        public String toString(String prefix) {
            return (prefix != null ? prefix : "") + this.directory.description() + ": " + (this.getTiffImageData() != null ? " (tiffImageData)" : "") + (this.getJpegImageData() != null ? " (jpegImageData)" : "") + "\n" + super.toString(prefix) + "\n";
        }

        public TiffOutputDirectory getOutputDirectory(int byteOrder) throws ImageWriteException {
            try {
                TiffOutputDirectory dstDir = new TiffOutputDirectory(this.type);
                ArrayList entries = this.getItems();
                for (int i = 0; i < entries.size(); ++i) {
                    Item item = (Item)entries.get(i);
                    TiffField srcField = item.getTiffField();
                    if (null != dstDir.findField(srcField.tag) || srcField.tagInfo instanceof TagInfo.Offset) continue;
                    TagInfo tagInfo = srcField.tagInfo;
                    FieldType fieldType = srcField.fieldType;
                    int count = srcField.length;
                    Object value = srcField.getValue();
                    byte[] bytes = tagInfo.encodeValue(fieldType, value, byteOrder);
                    TiffOutputField dstField = new TiffOutputField(srcField.tag, tagInfo, fieldType, count, bytes);
                    dstField.setSortHint(srcField.getSortHint());
                    dstDir.add(dstField);
                }
                dstDir.setTiffImageData(this.getTiffImageData());
                dstDir.setJpegImageData(this.getJpegImageData());
                return dstDir;
            }
            catch (ImageReadException e) {
                throw new ImageWriteException(e.getMessage(), e);
            }
        }
    }
}

