/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.properties.table;

import java.math.BigInteger;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.jaxb.Context;
import org.docx4j.model.properties.table.AbstractTableProperty;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.TblWidth;
import org.docx4j.wml.TcPrInner;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public abstract class AbstractCellMargin
extends AbstractTableProperty {
    protected static final String CSS_NAME_PREFIX = "padding-";
    protected static final String FO_NAME_PREFIX = "padding-";
    protected String cssAttributeName = null;
    protected String foAttributeName = null;
    int MAGIC_NUMBER = 240;

    protected AbstractCellMargin(TblWidth val, String suffix) {
        this.init(suffix);
        this.setObject(val);
    }

    public AbstractCellMargin(CSSValue value, String suffix) {
        int twip;
        CSSPrimitiveValue cssPrimitiveValue = (CSSPrimitiveValue)value;
        TblWidth tblWidth = Context.getWmlObjectFactory().createTblWidth();
        short ignored = 1;
        float fVal = cssPrimitiveValue.getFloatValue(ignored);
        short type = cssPrimitiveValue.getPrimitiveType();
        if (8 == type) {
            twip = UnitsOfMeasurement.inchToTwip(fVal);
        } else if (7 == type) {
            twip = UnitsOfMeasurement.mmToTwip(fVal);
        } else if (2 == type) {
            twip = this.twipFromPercentage(fVal);
        } else {
            log.error("No support for unit " + type);
            twip = 0;
        }
        this.init(suffix);
        tblWidth.setW(BigInteger.valueOf(twip));
        tblWidth.setType("dxa");
        this.setObject(tblWidth);
    }

    protected int twipFromPercentage(float fVal) {
        return Math.round((float)this.MAGIC_NUMBER * fVal / 100.0f);
    }

    protected void init(String suffix) {
        this.cssAttributeName = "padding-" + suffix;
        this.foAttributeName = "padding-" + suffix;
    }

    public String getCssProperty() {
        int twips = this.getTwips();
        String ret = null;
        if (twips > -1) {
            ret = AbstractCellMargin.composeCss(this.cssAttributeName, this.formatTwips(twips));
        }
        return ret;
    }

    public String getCssName() {
        return this.cssAttributeName;
    }

    public void setXslFO(Element foElement) {
        int twips = this.getTwips();
        if (twips > -1) {
            foElement.setAttribute(this.foAttributeName, this.formatTwips(twips));
        }
    }

    protected int getTwips() {
        TblWidth width = (TblWidth)this.getObject();
        int ret = -1;
        if (width != null && width.getW() != null) {
            ret = width.getW().intValue();
        }
        return ret;
    }

    protected String formatTwips(int twips) {
        return UnitsOfMeasurement.format2DP.format(UnitsOfMeasurement.twipToMm(twips)) + "mm";
    }

    protected void ensureMargin(TcPrInner tcPr) {
        if (tcPr.getTcMar() == null) {
            tcPr.setTcMar(Context.getWmlObjectFactory().createTcMar());
        }
    }

    public void ensureMargin(TblPr tblPr) {
        if (tblPr.getTblCellMar() == null) {
            tblPr.setTblCellMar(Context.getWmlObjectFactory().createCTTblCellMar());
        }
    }

    public abstract void set(TcPrInner var1);
}

