/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage.migration;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.utils.SingleTraversalUtilVisitorCallback;
import org.docx4j.utils.TraversalUtilVisitor;
import org.docx4j.wml.Body;
import org.docx4j.wml.Document;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariablePrepare {
    private static Logger log = LoggerFactory.getLogger(VariablePrepare.class);
    private static final QName _RT_QNAME = new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "t");

    public static void prepare(WordprocessingMLPackage wmlPackage) throws Exception {
        WordprocessingMLPackage.FilterSettings filterSettings = new WordprocessingMLPackage.FilterSettings();
        filterSettings.setRemoveProofErrors(true);
        filterSettings.setRemoveContentControls(true);
        filterSettings.setRemoveRsids(true);
        wmlPackage.filter(filterSettings);
        log.info(XmlUtils.marshaltoString(wmlPackage.getMainDocumentPart().getJaxbElement(), true, true));
        Document wmlDocumentEl = (Document)wmlPackage.getMainDocumentPart().getJaxbElement();
        Body body = wmlDocumentEl.getBody();
        SingleTraversalUtilVisitorCallback paragraphVisitor = new SingleTraversalUtilVisitorCallback(new TraversalUtilParagraphVisitor());
        paragraphVisitor.walkJAXBElements(body);
        log.info(XmlUtils.marshaltoString(wmlPackage.getMainDocumentPart().getJaxbElement(), true, true));
    }

    public static void joinupRuns(P p) {
        List<Object> existingContents = p.getContent();
        ArrayList<Object> newContents = new ArrayList<Object>();
        R currentR = null;
        String currentRPrString = null;
        for (Object o : existingContents) {
            if (o instanceof R) {
                if (currentR == null) {
                    currentR = (R)o;
                    if (currentR.getRPr() != null) {
                        currentRPrString = XmlUtils.marshaltoString(currentR.getRPr(), true);
                    }
                    newContents.add(currentR);
                    continue;
                }
                RPr other = ((R)o).getRPr();
                boolean makeNewRun = true;
                if (currentRPrString == null && other == null) {
                    makeNewRun = false;
                }
                if (currentRPrString != null && other != null && XmlUtils.marshaltoString(other, true).equals(currentRPrString)) {
                    makeNewRun = false;
                }
                if (makeNewRun) {
                    currentR = (R)o;
                    currentRPrString = currentR.getRPr() == null ? null : XmlUtils.marshaltoString(currentR.getRPr(), true);
                    newContents.add(currentR);
                    continue;
                }
                currentR.getContent().addAll(((R)o).getContent());
                continue;
            }
            newContents.add(o);
            currentR = null;
            currentRPrString = null;
        }
        for (Object o : newContents) {
            if (!(o instanceof R)) continue;
            ArrayList<Object> newRunContents = new ArrayList<Object>();
            JAXBElement currentT = null;
            for (Object rc : ((R)o).getContent()) {
                if (rc instanceof JAXBElement && ((JAXBElement)rc).getName().equals(_RT_QNAME)) {
                    if (currentT == null) {
                        currentT = (JAXBElement)rc;
                        newRunContents.add(currentT);
                    } else {
                        Text currentText = (Text)XmlUtils.unwrap(currentT);
                        String val = currentText.getValue();
                        currentText.setValue(val + ((Text)XmlUtils.unwrap(rc)).getValue());
                    }
                    if (((Text)XmlUtils.unwrap(rc)).getSpace() == null || !((Text)XmlUtils.unwrap(rc)).getSpace().equals("preserve")) continue;
                    ((Text)XmlUtils.unwrap(currentT)).setSpace("preserve");
                    continue;
                }
                log.debug(rc.getClass().getName());
                newRunContents.add(rc);
                currentT = null;
            }
            ((R)o).getContent().clear();
            ((R)o).getContent().addAll(newRunContents);
        }
        p.getContent().clear();
        p.getContent().addAll(newContents);
    }

    public static void main(String[] args) throws Exception {
        boolean save = true;
        String inputfilepath = System.getProperty("user.dir") + "/sample-docs/word/unmarshallFromTemplateDirtyExample.docx";
        WordprocessingMLPackage wmlPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        System.out.println(XmlUtils.marshaltoString(wmlPackage.getMainDocumentPart().getJaxbElement(), true, true));
        VariablePrepare.prepare(wmlPackage);
        System.out.println(XmlUtils.marshaltoString(wmlPackage.getMainDocumentPart().getJaxbElement(), true, true));
        if (save) {
            SaveToZipFile saver = new SaveToZipFile(wmlPackage);
            saver.save(System.getProperty("user.dir") + "/OUT_VariablePrepare.docx");
            System.out.println("Saved");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TraversalUtilParagraphVisitor
    extends TraversalUtilVisitor<P> {
        @Override
        public void apply(P p, Object parent, List<Object> siblings) {
            VariablePrepare.joinupRuns(p);
        }
    }
}

