/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.write;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryConstants;
import org.apache.sanselan.common.BinaryOutputStream;
import org.apache.sanselan.common.PackBits;
import org.apache.sanselan.common.mylzw.MyLZWCompressor;
import org.apache.sanselan.formats.tiff.TiffElement;
import org.apache.sanselan.formats.tiff.TiffImageData;
import org.apache.sanselan.formats.tiff.constants.TiffConstants;
import org.apache.sanselan.formats.tiff.write.TiffOutputDirectory;
import org.apache.sanselan.formats.tiff.write.TiffOutputField;
import org.apache.sanselan.formats.tiff.write.TiffOutputSet;
import org.apache.sanselan.formats.tiff.write.TiffOutputSummary;

public abstract class TiffImageWriterBase
implements TiffConstants,
BinaryConstants {
    protected final int byteOrder;

    public TiffImageWriterBase() {
        this.byteOrder = 73;
    }

    public TiffImageWriterBase(int byteOrder) {
        this.byteOrder = byteOrder;
    }

    protected static final int imageDataPaddingLength(int dataLength) {
        return (4 - dataLength % 4) % 4;
    }

    public abstract void write(OutputStream var1, TiffOutputSet var2) throws IOException, ImageWriteException;

    protected TiffOutputSummary validateDirectories(TiffOutputSet outputSet) throws ImageWriteException {
        List directories = outputSet.getDirectories();
        if (1 > directories.size()) {
            throw new ImageWriteException("No directories.");
        }
        TiffOutputDirectory exifDirectory = null;
        TiffOutputDirectory gpsDirectory = null;
        TiffOutputDirectory interoperabilityDirectory = null;
        TiffOutputField exifDirectoryOffsetField = null;
        TiffOutputField gpsDirectoryOffsetField = null;
        TiffOutputField interoperabilityDirectoryOffsetField = null;
        ArrayList<Integer> directoryIndices = new ArrayList<Integer>();
        HashMap<Integer, TiffOutputDirectory> directoryTypeMap = new HashMap<Integer, TiffOutputDirectory>();
        for (int i = 0; i < directories.size(); ++i) {
            TiffOutputDirectory directory;
            block33: {
                Integer key;
                int dirType;
                block32: {
                    directory = (TiffOutputDirectory)directories.get(i);
                    dirType = directory.type;
                    key = new Integer(dirType);
                    directoryTypeMap.put(key, directory);
                    if (dirType >= 0) break block32;
                    switch (dirType) {
                        case -2: {
                            if (exifDirectory != null) {
                                throw new ImageWriteException("More than one EXIF directory.");
                            }
                            exifDirectory = directory;
                            break block33;
                        }
                        case -3: {
                            if (gpsDirectory != null) {
                                throw new ImageWriteException("More than one GPS directory.");
                            }
                            gpsDirectory = directory;
                            break block33;
                        }
                        case -4: {
                            if (interoperabilityDirectory != null) {
                                throw new ImageWriteException("More than one Interoperability directory.");
                            }
                            interoperabilityDirectory = directory;
                            break block33;
                        }
                        default: {
                            throw new ImageWriteException("Unknown directory: " + dirType);
                        }
                    }
                }
                if (directoryIndices.contains(key)) {
                    throw new ImageWriteException("More than one directory with index: " + dirType + ".");
                }
                directoryIndices.add(new Integer(dirType));
            }
            HashSet<Integer> fieldTags = new HashSet<Integer>();
            ArrayList fields = directory.getFields();
            for (int j = 0; j < fields.size(); ++j) {
                TiffOutputField field = (TiffOutputField)fields.get(j);
                Integer fieldKey = new Integer(field.tag);
                if (fieldTags.contains(fieldKey)) {
                    throw new ImageWriteException("Tag (" + field.tagInfo.getDescription() + ") appears twice in directory.");
                }
                fieldTags.add(fieldKey);
                if (field.tag == TiffImageWriterBase.EXIF_TAG_EXIF_OFFSET.tag) {
                    if (exifDirectoryOffsetField != null) {
                        throw new ImageWriteException("More than one Exif directory offset field.");
                    }
                    exifDirectoryOffsetField = field;
                    continue;
                }
                if (field.tag == TiffImageWriterBase.EXIF_TAG_INTEROP_OFFSET.tag) {
                    if (interoperabilityDirectoryOffsetField != null) {
                        throw new ImageWriteException("More than one Interoperability directory offset field.");
                    }
                    interoperabilityDirectoryOffsetField = field;
                    continue;
                }
                if (field.tag != TiffImageWriterBase.EXIF_TAG_GPSINFO.tag) continue;
                if (gpsDirectoryOffsetField != null) {
                    throw new ImageWriteException("More than one GPS directory offset field.");
                }
                gpsDirectoryOffsetField = field;
            }
        }
        if (directoryIndices.size() < 1) {
            throw new ImageWriteException("Missing root directory.");
        }
        Collections.sort(directoryIndices);
        TiffOutputDirectory previousDirectory = null;
        for (int i = 0; i < directoryIndices.size(); ++i) {
            Integer index = (Integer)directoryIndices.get(i);
            if (index != i) {
                throw new ImageWriteException("Missing directory: " + i + ".");
            }
            TiffOutputDirectory directory = (TiffOutputDirectory)directoryTypeMap.get(index);
            if (null != previousDirectory) {
                previousDirectory.setNextDirectory(directory);
            }
            previousDirectory = directory;
        }
        TiffOutputDirectory rootDirectory = (TiffOutputDirectory)directoryTypeMap.get(new Integer(0));
        TiffOutputSummary result = new TiffOutputSummary(this.byteOrder, rootDirectory, directoryTypeMap);
        if (interoperabilityDirectory == null && interoperabilityDirectoryOffsetField != null) {
            throw new ImageWriteException("Output set has Interoperability Directory Offset field, but no Interoperability Directory");
        }
        if (interoperabilityDirectory != null) {
            if (exifDirectory == null) {
                exifDirectory = outputSet.addExifDirectory();
            }
            if (interoperabilityDirectoryOffsetField == null) {
                interoperabilityDirectoryOffsetField = TiffOutputField.createOffsetField(EXIF_TAG_INTEROP_OFFSET, this.byteOrder);
                exifDirectory.add(interoperabilityDirectoryOffsetField);
            }
            result.add(interoperabilityDirectory, interoperabilityDirectoryOffsetField);
        }
        if (exifDirectory == null && exifDirectoryOffsetField != null) {
            throw new ImageWriteException("Output set has Exif Directory Offset field, but no Exif Directory");
        }
        if (exifDirectory != null) {
            if (exifDirectoryOffsetField == null) {
                exifDirectoryOffsetField = TiffOutputField.createOffsetField(EXIF_TAG_EXIF_OFFSET, this.byteOrder);
                rootDirectory.add(exifDirectoryOffsetField);
            }
            result.add(exifDirectory, exifDirectoryOffsetField);
        }
        if (gpsDirectory == null && gpsDirectoryOffsetField != null) {
            throw new ImageWriteException("Output set has GPS Directory Offset field, but no GPS Directory");
        }
        if (gpsDirectory != null) {
            if (gpsDirectoryOffsetField == null) {
                gpsDirectoryOffsetField = TiffOutputField.createOffsetField(EXIF_TAG_GPSINFO, this.byteOrder);
                rootDirectory.add(gpsDirectoryOffsetField);
            }
            result.add(gpsDirectory, gpsDirectoryOffsetField);
        }
        return result;
    }

    public void writeImage(BufferedImage src, OutputStream os, Map params) throws ImageWriteException, IOException {
        int i;
        if ((params = new HashMap(params)).containsKey("FORMAT")) {
            params.remove("FORMAT");
        }
        String xmpXml = null;
        if (params.containsKey("XMP_XML")) {
            xmpXml = (String)params.get("XMP_XML");
            params.remove("XMP_XML");
        }
        int width = src.getWidth();
        int height = src.getHeight();
        int photometricInterpretation = 2;
        int compression = 5;
        if (params.containsKey("COMPRESSION")) {
            Object value = params.get("COMPRESSION");
            if (value != null) {
                if (!(value instanceof Number)) {
                    throw new ImageWriteException("Invalid compression parameter: " + value);
                }
                compression = ((Number)value).intValue();
            }
            params.remove("COMPRESSION");
        }
        int samplesPerPixel = 3;
        int bitsPerSample = 8;
        int rowsPerStrip = 8000 / (width * 3);
        rowsPerStrip = Math.max(1, rowsPerStrip);
        byte[][] strips = this.getStrips(src, 3, 8, rowsPerStrip);
        if (params.size() > 0) {
            Object firstKey = params.keySet().iterator().next();
            throw new ImageWriteException("Unknown parameter: " + firstKey);
        }
        if (compression == 32773) {
            for (i = 0; i < strips.length; ++i) {
                strips[i] = new PackBits().compress(strips[i]);
            }
        } else if (compression == 5) {
            for (i = 0; i < strips.length; ++i) {
                byte[] uncompressed = strips[i];
                int LZW_MINIMUM_CODE_SIZE = 8;
                MyLZWCompressor compressor = new MyLZWCompressor(LZW_MINIMUM_CODE_SIZE, 77, true);
                byte[] compressed = compressor.compress(uncompressed);
                strips[i] = compressed;
            }
        } else if (compression != 1) {
            throw new ImageWriteException("Invalid compression parameter (Only LZW, Packbits and uncompressed supported).");
        }
        TiffElement.DataElement[] imageData = new TiffElement.DataElement[strips.length];
        for (int i2 = 0; i2 < strips.length; ++i2) {
            imageData[i2] = new TiffImageData.Data(0, strips[i2].length, strips[i2]);
        }
        TiffOutputSet outputSet = new TiffOutputSet(this.byteOrder);
        TiffOutputDirectory directory = outputSet.addRootDirectory();
        TiffOutputField field = new TiffOutputField(TIFF_TAG_IMAGE_WIDTH, FIELD_TYPE_LONG, 1, FIELD_TYPE_LONG.writeData(new int[]{width}, this.byteOrder));
        directory.add(field);
        field = new TiffOutputField(TIFF_TAG_IMAGE_LENGTH, FIELD_TYPE_LONG, 1, FIELD_TYPE_LONG.writeData(new int[]{height}, this.byteOrder));
        directory.add(field);
        field = new TiffOutputField(TIFF_TAG_PHOTOMETRIC_INTERPRETATION, FIELD_TYPE_SHORT, 1, FIELD_TYPE_SHORT.writeData(new int[]{2}, this.byteOrder));
        directory.add(field);
        field = new TiffOutputField(TIFF_TAG_COMPRESSION, FIELD_TYPE_SHORT, 1, FIELD_TYPE_SHORT.writeData(new int[]{compression}, this.byteOrder));
        directory.add(field);
        field = new TiffOutputField(TIFF_TAG_SAMPLES_PER_PIXEL, FIELD_TYPE_SHORT, 1, FIELD_TYPE_SHORT.writeData(new int[]{3}, this.byteOrder));
        directory.add(field);
        field = new TiffOutputField(TIFF_TAG_BITS_PER_SAMPLE, FIELD_TYPE_SHORT, 3, FIELD_TYPE_SHORT.writeData(new int[]{8, 8, 8}, this.byteOrder));
        directory.add(field);
        field = new TiffOutputField(TIFF_TAG_ROWS_PER_STRIP, FIELD_TYPE_LONG, 1, FIELD_TYPE_LONG.writeData(new int[]{rowsPerStrip}, this.byteOrder));
        directory.add(field);
        int resolutionUnit = 2;
        TiffOutputField field2 = new TiffOutputField(TIFF_TAG_RESOLUTION_UNIT, FIELD_TYPE_SHORT, 1, FIELD_TYPE_SHORT.writeData(new int[]{resolutionUnit}, this.byteOrder));
        directory.add(field2);
        int xResolution = 72;
        field2 = new TiffOutputField(TIFF_TAG_XRESOLUTION, FIELD_TYPE_RATIONAL, 1, FIELD_TYPE_RATIONAL.writeData(xResolution, 1, this.byteOrder));
        directory.add(field2);
        int yResolution = 72;
        field2 = new TiffOutputField(TIFF_TAG_YRESOLUTION, FIELD_TYPE_RATIONAL, 1, FIELD_TYPE_RATIONAL.writeData(yResolution, 1, this.byteOrder));
        directory.add(field2);
        if (null != xmpXml) {
            byte[] xmpXmlBytes = xmpXml.getBytes("utf-8");
            field2 = new TiffOutputField(TIFF_TAG_XMP, FIELD_TYPE_BYTE, xmpXmlBytes.length, xmpXmlBytes);
            directory.add(field2);
        }
        TiffImageData.Strips tiffImageData = new TiffImageData.Strips(imageData, rowsPerStrip);
        directory.setTiffImageData(tiffImageData);
        this.write(os, outputSet);
    }

    private byte[][] getStrips(BufferedImage src, int samplesPerPixel, int bitsPerSample, int rowsPerStrip) {
        int width = src.getWidth();
        int height = src.getHeight();
        int stripCount = (height + rowsPerStrip - 1) / rowsPerStrip;
        Object result = null;
        result = new byte[stripCount][];
        int remaining_rows = height;
        for (int i = 0; i < stripCount; ++i) {
            int rowsInStrip = Math.min(rowsPerStrip, remaining_rows);
            remaining_rows -= rowsInStrip;
            int bitsInStrip = bitsPerSample * rowsInStrip * width * samplesPerPixel;
            int bytesInStrip = (bitsInStrip + 7) / 8;
            byte[] uncompressed = new byte[bytesInStrip];
            int counter = 0;
            int stop = i * rowsPerStrip + rowsPerStrip;
            for (int y = i * rowsPerStrip; y < height && y < stop; ++y) {
                for (int x = 0; x < width; ++x) {
                    int rgb = src.getRGB(x, y);
                    int red = 0xFF & rgb >> 16;
                    int green = 0xFF & rgb >> 8;
                    int blue = 0xFF & rgb >> 0;
                    uncompressed[counter++] = (byte)red;
                    uncompressed[counter++] = (byte)green;
                    uncompressed[counter++] = (byte)blue;
                }
            }
            result[i] = uncompressed;
        }
        return result;
    }

    protected void writeImageFileHeader(BinaryOutputStream bos) throws IOException, ImageWriteException {
        int offsetToFirstIFD = 8;
        this.writeImageFileHeader(bos, offsetToFirstIFD);
    }

    protected void writeImageFileHeader(BinaryOutputStream bos, int offsetToFirstIFD) throws IOException, ImageWriteException {
        bos.write(this.byteOrder);
        bos.write(this.byteOrder);
        bos.write2Bytes(42);
        bos.write4Bytes(offsetToFirstIFD);
    }
}

