/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.xml.esc;

import com.topologi.diffx.xml.esc.XMLEscape;
import com.topologi.diffx.xml.esc.XMLEscapeBase;

public final class XMLEscapeASCII
extends XMLEscapeBase
implements XMLEscape {
    public static final XMLEscape ASCII_ESCAPE = new XMLEscapeASCII();
    private static final String ENCODING = "ASCII";

    private XMLEscapeASCII() {
        super(ENCODING);
    }

    public String toAttributeValue(char[] ch, int off, int len) {
        StringBuffer out = new StringBuffer(len + len / 10);
        for (int i = off; i < off + len; ++i) {
            if (ch[i] < ' ') {
                if (ch[i] == '\t' || ch[i] == '\n' || ch[i] == '\r') {
                    out.append(ch[i]);
                    continue;
                }
                this.doNothing();
                continue;
            }
            if (ch[i] < '\u0080') {
                switch (ch[i]) {
                    case '&': {
                        out.append("&amp;");
                        break;
                    }
                    case '<': {
                        out.append("&lt;");
                        break;
                    }
                    case '\"': {
                        out.append("&quot;");
                        break;
                    }
                    case '\'': {
                        out.append("&apos;");
                        break;
                    }
                    default: {
                        out.append(ch[i]);
                        break;
                    }
                }
                continue;
            }
            if (ch[i] < '\u00a0') {
                this.doNothing();
                continue;
            }
            out.append("&#x").append((int)ch[i]).append(';');
        }
        return out.toString();
    }

    public String toElementText(char[] ch, int off, int len) {
        StringBuffer out = new StringBuffer(len + len / 10);
        for (int i = off; i < off + len; ++i) {
            if (ch[i] < ' ') {
                if (ch[i] == '\t' || ch[i] == '\n' || ch[i] == '\r') {
                    out.append(ch[i]);
                    continue;
                }
                this.doNothing();
                continue;
            }
            if (ch[i] < '\u0080') {
                switch (ch[i]) {
                    case '&': {
                        out.append("&amp;");
                        break;
                    }
                    case '<': {
                        out.append("&lt;");
                        break;
                    }
                    default: {
                        out.append(ch[i]);
                        break;
                    }
                }
                continue;
            }
            if (ch[i] < '\u00a0') {
                this.doNothing();
                continue;
            }
            out.append("&#x").append((int)ch[i]).append(';');
        }
        return out.toString();
    }

    private void doNothing() {
    }
}

