/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.tables;

import org.docx4j.wml.Tbl;
import org.lysis.reporters.tools.DOCX4R;
import org.lysis.reporters.tools.DocComponent;
import org.lysis.reporters.tools.HTML4R;
import org.lysis.reporters.tools.PPTX4R;
import org.pptx4j.pml.CTGraphicalObjectFrame;

public class XMLreader extends DocComponent implements HTML4R, PPTX4R, DOCX4R {

	private String value;
	public XMLreader(String str ) {
		value = str;
	}

	public CTGraphicalObjectFrame get_flextable_pptx( ) throws Exception{
		
		java.util.HashMap<String, String>mappings = new java.util.HashMap<String, String>();

        Object o = org.docx4j.XmlUtils.unmarshallFromTemplate(value, mappings, org.pptx4j.jaxb.Context.jcPML, CTGraphicalObjectFrame.class ) ;
        CTGraphicalObjectFrame out = (CTGraphicalObjectFrame)o;
        out.setXfrm(this.getXfrm());
        out.getNvGraphicFramePr().getCNvPr().setId(this.unique_id);
		return out;
		}
	
	public Tbl get_docx_elt() throws Exception{
		java.util.HashMap<String, String>mappings = new java.util.HashMap<String, String>();

        Object o = org.docx4j.XmlUtils.unmarshallFromTemplate(value, mappings, org.docx4j.jaxb.Context.jc, Tbl.class ) ;
        Tbl out = (Tbl)o;
		return out;
	}
	
	@Override
	public String getHTML() {
		return value;
	}

	
	@Override
	public String getCSS() {
		return "";
	}

	@Override
	public String getJS() {
		return "";
	}

	@Override
	public boolean hasJS() {
		return false;
	}

	@Override
	public boolean hasHTML() {
		return true;
	}

	@Override
	public boolean hasCSS() {
		return false;
	}
	
}
